/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.trace;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.CoyoteOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperOutputStream
extends ServletOutputStream {
    private static final Logger log = LoggerFactory.getLogger(WrapperOutputStream.class);
    private OutputStream innerOut;
    private HttpServletResponse response;

    public WrapperOutputStream(OutputStream innerOut, HttpServletResponse response) {
        this.response = response;
        this.innerOut = innerOut;
    }

    public boolean isReady() {
        if (this.response == null) {
            return false;
        }
        try {
            return this.response.getOutputStream().isReady();
        }
        catch (IOException e) {
            log.error("got exception when check if  the output stream is ready", (Throwable)e);
            return false;
        }
    }

    public void setWriteListener(WriteListener listener) {
        if (this.response != null) {
            try {
                ((CoyoteOutputStream)this.response.getOutputStream()).setWriteListener(listener);
            }
            catch (IOException e) {
                log.error("got exception when set write listener", (Throwable)e);
            }
        }
    }

    public void write(int b) throws IOException {
        if (this.response != null) {
            this.response.getOutputStream().write(b);
        }
        this.innerOut.write(b);
    }
}

