/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"regexp_split_to_array"}, parameter="(String source_string, String regexp, String flags)", descriptions={"- Return \"\" if any of the arguments are NULL or invalid;", "- Return a string from 'source_string' with all the substrings that match a regular expression 'regexp' consecutively being replaced with 'replacement'.", "Note: 'flags' is one of  ('g' -> flag can be used when we want to match all the substrings that occur, 'i' -> flag to ignore case for matching, 'x' -> flag to extend syntax (ignoring whitespace and comments in regular expressions), 'm' and 'n' -> flag allows regular expressions to match across multiple lines)."}, examples={"regexp_split_to_array(\"hello world\",\"\\s+\") = {hello, world}"})
public class RegexpSplitToArrayFunction
implements ValueParser {
    private ValueParser inputParser;
    private ValueParser patternParser;
    private ValueParser flagParser;

    public RegexpSplitToArrayFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null) {
            this.inputParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.patternParser = OperatorTools.buildParser((Expression)expressions.get(1));
            if (expressions.size() == 3) {
                this.flagParser = OperatorTools.buildParser((Expression)expressions.get(2));
            }
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.inputParser == null || this.patternParser == null) {
            return null;
        }
        String inputString = OperatorTools.parseString(this.inputParser.parse(sourceData, rowIndex, context));
        String patternString = OperatorTools.parseString(this.patternParser.parse(sourceData, rowIndex, context));
        String flagString = "";
        if (this.flagParser != null) {
            flagString = OperatorTools.parseString(this.flagParser.parse(sourceData, rowIndex, context));
        }
        return this.regexpSplitToArray(inputString, patternString, flagString);
    }

    private List<String> regexpSplitToArray(String inputString, String patternString, String flagString) {
        int regexFlags = 0;
        if (flagString != null) {
            if (flagString.contains("i")) {
                regexFlags |= 2;
            }
            if (flagString.contains("m") || flagString.contains("n")) {
                regexFlags |= 8;
            }
            if (flagString.contains("s")) {
                regexFlags |= 0x20;
            }
            if (flagString.contains("x")) {
                regexFlags |= 4;
            }
        }
        Pattern pattern = Pattern.compile(patternString, regexFlags);
        return Arrays.asList(pattern.split(inputString));
    }
}

