/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.WhenClause;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.ExpressionOperator;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformParser(values={CaseExpression.class})
public class CaseParser
implements ValueParser {
    private final ValueParser switchValue;
    private final List<CaseWhen> caseWhens;
    private final ValueParser elseResult;

    public CaseParser(CaseExpression expr) {
        this.switchValue = OperatorTools.buildParser(expr.getSwitchExpression());
        this.caseWhens = new ArrayList<CaseWhen>();
        this.elseResult = OperatorTools.buildParser(expr.getElseExpression());
        for (WhenClause whenClause : expr.getWhenClauses()) {
            Object condition = null;
            condition = this.switchValue == null ? OperatorTools.buildOperator(whenClause.getWhenExpression()) : OperatorTools.buildParser(whenClause.getWhenExpression());
            ValueParser result = OperatorTools.buildParser(whenClause.getThenExpression());
            this.caseWhens.add(new CaseWhen(condition, result));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.switchValue == null) {
            for (CaseWhen caseWhen : this.caseWhens) {
                if (!((ExpressionOperator)caseWhen.condition).check(sourceData, rowIndex, context)) continue;
                return caseWhen.result.parse(sourceData, rowIndex, context);
            }
        } else {
            for (CaseWhen caseWhen : this.caseWhens) {
                Comparable right;
                Comparable left = (Comparable)this.switchValue.parse(sourceData, rowIndex, context);
                if (OperatorTools.compareValue(left, right = (Comparable)((ValueParser)caseWhen.condition).parse(sourceData, rowIndex, context)) != 0) continue;
                return caseWhen.result.parse(sourceData, rowIndex, context);
            }
        }
        return this.elseResult == null ? null : this.elseResult.parse(sourceData, rowIndex, context);
    }

    private static class CaseWhen {
        private final Object condition;
        private final ValueParser result;

        public CaseWhen(Object condition, ValueParser result) {
            this.condition = condition;
            this.result = result;
        }
    }
}

