/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeStrategyFactory;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergSink;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.source.iceberg.IcebergSource;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.MetaFieldInfo;
import org.apache.inlong.sort.protocol.constant.IcebergConstant;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.extract.IcebergExtractNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.load.IcebergLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcebergProvider
implements ExtractNodeProvider,
LoadNodeProvider {
    private static final Logger log = LoggerFactory.getLogger(IcebergProvider.class);
    @Autowired
    private FieldTypeStrategyFactory fieldTypeStrategyFactory;

    @Override
    public Boolean accept(String sinkType) {
        return "ICEBERG".equals(sinkType);
    }

    @Override
    public ExtractNode createExtractNode(StreamNode streamNodeInfo) {
        IcebergSource icebergSource = (IcebergSource)streamNodeInfo;
        FieldTypeMappingStrategy fieldTypeMappingStrategy = this.fieldTypeStrategyFactory.getInstance(icebergSource.getSourceType());
        List<FieldInfo> fieldInfos = this.parseStreamFieldInfos(icebergSource.getFieldList(), icebergSource.getSourceName(), fieldTypeMappingStrategy);
        Map<String, String> properties = this.parseProperties(icebergSource.getProperties());
        return new IcebergExtractNode(icebergSource.getSourceName(), icebergSource.getSourceName(), fieldInfos, null, icebergSource.getUri(), icebergSource.getWarehouse(), icebergSource.getDatabase(), icebergSource.getTableName(), IcebergConstant.CatalogType.HIVE, "HIVE", icebergSource.getPrimaryKey(), null, properties);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        IcebergSink icebergSink = (IcebergSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(icebergSink.getProperties());
        FieldTypeMappingStrategy fieldTypeMappingStrategy = this.fieldTypeStrategyFactory.getInstance(icebergSink.getSinkType());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(icebergSink.getSinkFieldList(), icebergSink.getSinkName(), fieldTypeMappingStrategy);
        List<FieldRelation> fieldRelations = this.parseSinkFields(icebergSink.getSinkFieldList(), constantFieldMap);
        IcebergConstant.CatalogType catalogType = IcebergConstant.CatalogType.forName((String)icebergSink.getCatalogType());
        Format format = this.parsingSinkMultipleFormat(icebergSink.getSinkMultipleEnable(), icebergSink.getSinkMultipleFormat());
        return new IcebergLoadNode(icebergSink.getSinkName(), icebergSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, icebergSink.getDbName(), icebergSink.getTableName(), icebergSink.getPrimaryKey(), catalogType, icebergSink.getCatalogUri(), icebergSink.getWarehouse(), icebergSink.getAppendMode(), icebergSink.getSinkMultipleEnable(), format, icebergSink.getDatabasePattern(), icebergSink.getTablePattern(), icebergSink.getEnableSchemaChange().booleanValue(), null);
    }

    @Override
    public List<StreamField> addStreamMetaFields(List<StreamField> streamFields) {
        List fieldNames = streamFields.stream().map(StreamField::getFieldName).collect(Collectors.toList());
        if (!fieldNames.contains(MetaField.AUDIT_DATA_TIME.name())) {
            streamFields.add(0, new StreamField(0, "long", MetaField.AUDIT_DATA_TIME.name(), "data_time", null, 1, MetaField.AUDIT_DATA_TIME.name()));
        }
        return streamFields;
    }

    @Override
    public List<SinkField> addSinkMetaFields(List<SinkField> sinkFields) {
        List fieldNames = sinkFields.stream().map(SinkField::getFieldName).collect(Collectors.toList());
        if (!fieldNames.contains(MetaField.AUDIT_DATA_TIME.name())) {
            sinkFields.add(0, new SinkField(0, "long", MetaField.AUDIT_DATA_TIME.name(), "iceberg meta field", MetaField.AUDIT_DATA_TIME.name(), "long", 1, MetaField.AUDIT_DATA_TIME.name(), null));
        }
        return sinkFields;
    }

    @Override
    public List<FieldInfo> getMetaFields() {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        fieldInfos.add(0, (FieldInfo)new MetaFieldInfo(MetaField.AUDIT_DATA_TIME.name(), MetaField.AUDIT_DATA_TIME));
        return fieldInfos;
    }

    @Override
    public Boolean isSinkMultiple(StreamNode nodeInfo) {
        IcebergSink icebergSink = (IcebergSink)nodeInfo;
        return icebergSink.getSinkMultipleEnable();
    }

    @Override
    public List<StreamField> addStreamFieldsForSinkMultiple(List<StreamField> streamFields) {
        if (CollectionUtils.isEmpty(streamFields)) {
            streamFields = new ArrayList<StreamField>();
        }
        streamFields.add(0, new StreamField(0, "varbinary", MetaField.DATA_BYTES_CANAL.name(), "meta.data_canal", null, 1, MetaField.DATA_BYTES_CANAL.name()));
        return streamFields;
    }

    @Override
    public List<SinkField> addSinkFieldsForSinkMultiple(List<SinkField> sinkFields) {
        if (CollectionUtils.isEmpty(sinkFields)) {
            sinkFields = new ArrayList<SinkField>();
        }
        sinkFields.add(0, new SinkField(0, "varbinary", MetaField.DATA_BYTES_CANAL.name(), "meta.data_canal", MetaField.DATA_BYTES_CANAL.name(), "varbinary", 0, MetaField.DATA_BYTES_CANAL.name(), null));
        return sinkFields;
    }
}

