/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.InlongMetric;
import org.apache.inlong.sort.protocol.Metadata;
import org.apache.inlong.sort.protocol.constant.IcebergConstant;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeName(value="icebergExtract")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class IcebergExtractNode
extends ExtractNode
implements InlongMetric,
Metadata,
Serializable {
    @JsonProperty(value="tableName")
    @Nonnull
    private String tableName;
    @JsonProperty(value="dbName")
    @Nonnull
    private String dbName;
    @JsonProperty(value="catalogType")
    private IcebergConstant.CatalogType catalogType;
    @Nullable
    @JsonProperty(value="uri")
    private String uri;
    @JsonProperty(value="warehouse")
    private String warehouse;
    @JsonProperty(value="catalogName")
    private String catalogName;
    @JsonProperty(value="primaryKey")
    private String primaryKey;
    @JsonProperty(value="startSnapShotId")
    @Nullable
    private Long startSnapShotId;

    public IcebergExtractNode(@Nonnull @JsonProperty(value="id") String id, @Nonnull @JsonProperty(value="name") String name, @Nonnull @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermarkField") WatermarkField watermarkField, @Nullable @JsonProperty(value="uri") String uri, @Nullable @JsonProperty(value="warehouse") String warehouse, @Nonnull @JsonProperty(value="dbName") String dbName, @Nonnull @JsonProperty(value="tableName") String tableName, @JsonProperty(value="catalogType") IcebergConstant.CatalogType catalogType, @Nullable @JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="primaryKey") String primaryKey, @Nullable @JsonProperty(value="startSnapShotId") Long startSnapShotId, @Nullable @JsonProperty(value="properties") Map<String, String> properties) {
        super(id, name, fields, watermarkField, properties);
        this.uri = uri;
        this.warehouse = warehouse;
        this.dbName = dbName;
        this.tableName = tableName;
        this.catalogName = catalogName == null ? "ICEBERG_HIVE" : catalogName;
        this.primaryKey = primaryKey;
        this.startSnapShotId = startSnapShotId;
        this.catalogType = catalogType == null ? IcebergConstant.CatalogType.HIVE : catalogType;
    }

    @Override
    public String genTableName() {
        return String.format("iceberg_table_%s", this.getId());
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> options = super.tableOptions();
        options.put("connector", "iceberg-inlong");
        options.put("catalog-database", this.dbName);
        options.put("catalog-table", this.tableName);
        options.put("catalog-type", this.catalogType.name());
        options.put("catalog-name", this.catalogName);
        options.put("streaming", "true");
        options.put("starting-strategy", IcebergConstant.StreamingStartingStrategy.TABLE_SCAN_THEN_INCREMENTAL.name());
        if (null != this.uri) {
            options.put("uri", this.uri);
        }
        if (null != this.warehouse) {
            options.put("warehouse", this.warehouse);
        }
        if (null != this.startSnapShotId) {
            options.put("start-snapshot-id", this.startSnapShotId.toString());
            options.put("starting-strategy", IcebergConstant.StreamingStartingStrategy.INCREMENTAL_FROM_SNAPSHOT_ID.name());
        }
        return options;
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public List<FieldInfo> getPartitionFields() {
        return super.getPartitionFields();
    }

    @Override
    public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        switch (metaField) {
            case AUDIT_DATA_TIME: {
                metadataKey = "audit_data_time";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", this.getClass().getSimpleName(), metaField));
            }
        }
        return metadataKey;
    }

    @Override
    public boolean isVirtual(MetaField metaField) {
        return true;
    }

    @Override
    public Set<MetaField> supportedMetaFields() {
        return EnumSet.of(MetaField.AUDIT_DATA_TIME);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergExtractNode)) {
            return false;
        }
        IcebergExtractNode other = (IcebergExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$startSnapShotId = this.getStartSnapShotId();
        Long other$startSnapShotId = other.getStartSnapShotId();
        if (this$startSnapShotId == null ? other$startSnapShotId != null : !((Object)this$startSnapShotId).equals(other$startSnapShotId)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        IcebergConstant.CatalogType this$catalogType = this.getCatalogType();
        IcebergConstant.CatalogType other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !((Object)((Object)this$catalogType)).equals((Object)other$catalogType)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$catalogName = this.getCatalogName();
        String other$catalogName = other.getCatalogName();
        if (this$catalogName == null ? other$catalogName != null : !this$catalogName.equals(other$catalogName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IcebergExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $startSnapShotId = this.getStartSnapShotId();
        result = result * 59 + ($startSnapShotId == null ? 43 : ((Object)$startSnapShotId).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        IcebergConstant.CatalogType $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : ((Object)((Object)$catalogType)).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $catalogName = this.getCatalogName();
        result = result * 59 + ($catalogName == null ? 43 : $catalogName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    @Nonnull
    public String getTableName() {
        return this.tableName;
    }

    @Nonnull
    public String getDbName() {
        return this.dbName;
    }

    public IcebergConstant.CatalogType getCatalogType() {
        return this.catalogType;
    }

    @Nullable
    public String getUri() {
        return this.uri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    @Nullable
    public Long getStartSnapShotId() {
        return this.startSnapShotId;
    }

    public void setTableName(@Nonnull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        this.tableName = tableName;
    }

    public void setDbName(@Nonnull String dbName) {
        if (dbName == null) {
            throw new NullPointerException("dbName is marked non-null but is null");
        }
        this.dbName = dbName;
    }

    public void setCatalogType(IcebergConstant.CatalogType catalogType) {
        this.catalogType = catalogType;
    }

    public void setUri(@Nullable String uri) {
        this.uri = uri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setStartSnapShotId(@Nullable Long startSnapShotId) {
        this.startSnapShotId = startSnapShotId;
    }

    @Override
    public String toString() {
        return "IcebergExtractNode(tableName=" + this.getTableName() + ", dbName=" + this.getDbName() + ", catalogType=" + (Object)((Object)this.getCatalogType()) + ", uri=" + this.getUri() + ", warehouse=" + this.getWarehouse() + ", catalogName=" + this.getCatalogName() + ", primaryKey=" + this.getPrimaryKey() + ", startSnapShotId=" + this.getStartSnapShotId() + ")";
    }
}

