/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.metric.impl;

import java.util.Map;
import org.apache.inlong.tubemq.corebase.metric.Histogram;
import org.apache.inlong.tubemq.corebase.metric.impl.BaseMetric;
import org.apache.inlong.tubemq.corebase.metric.impl.LongMaxGauge;
import org.apache.inlong.tubemq.corebase.metric.impl.LongMinGauge;
import org.apache.inlong.tubemq.corebase.metric.impl.LongStatsCounter;

public class SimpleHistogram
extends BaseMetric
implements Histogram {
    private final LongStatsCounter count = new LongStatsCounter("count", this.getFullName());
    private final LongMinGauge min = new LongMinGauge("min", this.getFullName());
    private final LongMaxGauge max = new LongMaxGauge("max", this.getFullName());

    public SimpleHistogram(String metricName, String prefix) {
        super(metricName, prefix);
    }

    @Override
    public void update(long newValue) {
        this.count.incValue();
        this.min.update(newValue);
        this.max.update(newValue);
    }

    @Override
    public void getValue(Map<String, Long> keyValMap, boolean includeZero) {
        keyValMap.put(this.count.getFullName(), this.count.getValue());
        keyValMap.put(this.min.getFullName(), this.min.getValue());
        keyValMap.put(this.max.getFullName(), this.max.getValue());
    }

    @Override
    public void getValue(StringBuilder strBuff, boolean includeZero) {
        strBuff.append("\"").append(this.getFullName()).append("\":{\"").append(this.count.getShortName()).append("\":").append(this.count.getValue()).append(",\"").append(this.min.getShortName()).append("\":").append(this.min.getValue()).append(",\"").append(this.max.getShortName()).append("\":").append(this.max.getValue()).append("}");
    }

    @Override
    public void snapShort(Map<String, Long> keyValMap, boolean includeZero) {
        keyValMap.put(this.count.getFullName(), this.count.getAndResetValue());
        keyValMap.put(this.min.getFullName(), this.min.getAndResetValue());
        keyValMap.put(this.max.getFullName(), this.max.getAndResetValue());
    }

    @Override
    public void snapShort(StringBuilder strBuff, boolean includeZero) {
        strBuff.append("\"").append(this.getFullName()).append("\":{\"").append(this.count.getShortName()).append("\":").append(this.count.getAndResetValue()).append(",\"").append(this.min.getShortName()).append("\":").append(this.min.getAndResetValue()).append(",\"").append(this.max.getShortName()).append("\":").append(this.max.getAndResetValue()).append("}");
    }

    @Override
    public void clear() {
        this.count.clear();
        this.min.clear();
        this.max.clear();
    }
}

