/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.fasterxml.classmate.ResolvedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import springfox.documentation.schema.Enums;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;

public class BuilderDefaults {
    private BuilderDefaults() {
        throw new UnsupportedOperationException();
    }

    public static <T> T defaultIfAbsent(T newValue, T defaultValue) {
        return Optional.ofNullable(newValue).orElse(Optional.ofNullable(defaultValue).orElse(null));
    }

    public static <T> List<T> nullToEmptyList(Collection<T> newValue) {
        if (newValue == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(newValue);
    }

    public static <T> T[] nullToEmptyArray(T[] newValues) {
        if (newValues == null) {
            return new Object[0];
        }
        return newValues;
    }

    public static <K, V> Map<K, V> nullToEmptyMap(Map<K, V> newValue) {
        if (newValue == null) {
            return new HashMap();
        }
        return newValue;
    }

    public static <K, V> Map<K, List<V>> nullToEmptyMultimap(Map<K, List<V>> newValue) {
        if (newValue == null) {
            return new HashMap();
        }
        return newValue;
    }

    public static <T> Set<T> nullToEmptySet(Set<T> newValue) {
        if (newValue == null) {
            return new HashSet();
        }
        return newValue;
    }

    public static ResolvedType replaceIfMoreSpecific(ResolvedType replacement, ResolvedType defaultValue) {
        ResolvedType toReturn = BuilderDefaults.defaultIfAbsent(replacement, defaultValue);
        if (BuilderDefaults.isObject(replacement) && BuilderDefaults.isNotObject(defaultValue)) {
            return defaultValue;
        }
        return toReturn;
    }

    private static boolean isNotObject(ResolvedType defaultValue) {
        return defaultValue != null && !Object.class.equals((Object)defaultValue.getErasedType());
    }

    private static boolean isObject(ResolvedType replacement) {
        return replacement != null && Object.class.equals((Object)replacement.getErasedType());
    }

    public static AllowableValues emptyToNull(AllowableValues newValue, AllowableValues current) {
        if (newValue != null) {
            if (newValue instanceof AllowableListValues) {
                return BuilderDefaults.defaultIfAbsent(Enums.emptyListValuesToNull((AllowableListValues)newValue), current);
            }
            return BuilderDefaults.defaultIfAbsent(newValue, current);
        }
        return current;
    }

    public static String emptyToNull(String test) {
        if (test != null && test.length() == 0) {
            return null;
        }
        return test;
    }

    public static String nullToEmpty(String test) {
        if (test == null) {
            return "";
        }
        return test;
    }
}

