/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.Objects;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ModelSpecification;

public class Header {
    private final String name;
    private final ModelReference modelReference;
    private final ModelSpecification modelSpecification;
    private final String description;
    private final Boolean required;

    public Header(String name, String description, ModelReference modelReference, ModelSpecification modelSpecification) {
        this(name, description, modelReference, modelSpecification, true);
    }

    public Header(String name, String description, ModelReference modelReference, ModelSpecification modelSpecification, Boolean required) {
        this.name = name;
        this.modelReference = modelReference;
        this.description = description;
        this.modelSpecification = modelSpecification;
        this.required = required;
    }

    public String getName() {
        return this.name;
    }

    public ModelReference getModelReference() {
        return this.modelReference;
    }

    public String getDescription() {
        return this.description;
    }

    public ModelSpecification getModelSpecification() {
        return this.modelSpecification;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return Objects.equals(this.name, header.name) && Objects.equals(this.modelReference, header.modelReference) && Objects.equals(this.modelSpecification, header.modelSpecification) && Objects.equals(this.required, header.required) && Objects.equals(this.description, header.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.modelReference, this.modelSpecification, this.description, this.required);
    }

    public String toString() {
        return new StringBuffer(this.getClass().getSimpleName()).append("{").append("name=").append(this.name).append(", ").append("modelReference=").append(this.modelReference).append(", ").append("modelSpecification=").append(this.modelSpecification).append(", ").append("description=").append(this.description).append("required=").append(this.required).append("}").toString();
    }
}

