/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.commons.protocol;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.flume.event.SimpleEvent;
import org.apache.inlong.sdk.commons.protocol.InlongId;

public class SdkEvent
extends SimpleEvent {
    protected String inlongGroupId;
    protected String inlongStreamId;
    protected String uid;
    protected long msgTime;
    protected String sourceIp;

    public SdkEvent() {
    }

    public SdkEvent(String inlongGroupId, String inlongStreamId, byte[] body) {
        this.inlongGroupId = inlongGroupId;
        this.inlongStreamId = inlongStreamId;
        super.setBody(body);
        this.uid = InlongId.generateUid(inlongGroupId, inlongStreamId);
        this.msgTime = System.currentTimeMillis();
        this.sourceIp = "127.0.0.1";
        Map headers = super.getHeaders();
        headers.put("inlongGroupId", inlongGroupId);
        headers.put("inlongStreamId", inlongStreamId);
        headers.put("msgTime", String.valueOf(this.msgTime));
    }

    public SdkEvent(String inlongGroupId, String inlongStreamId, String body) {
        this(inlongGroupId, inlongStreamId, body.getBytes(Charset.defaultCharset()));
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public void setSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
        this.getHeaders().put("sourceIp", sourceIp);
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getUid() {
        return this.uid;
    }

    public long getMsgTime() {
        return this.msgTime;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setMsgTime(long msgTime) {
        this.msgTime = msgTime;
    }
}

