/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.bdbstore.bdbentitys;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.server.common.statusdef.EnableStatus;

@Entity
public class BdbGroupFlowCtrlEntity
implements Serializable {
    private static final long serialVersionUID = 2533735122504168321L;
    @PrimaryKey
    private String groupName;
    private long serialId = -1L;
    private int statusId = -1;
    private String flowCtrlInfo;
    private int ruleCnt = 0;
    private long ssdTranslateId = System.currentTimeMillis();
    private boolean needSSDProc = false;
    private String attributes;
    private String createUser;
    private Date createDate;

    public BdbGroupFlowCtrlEntity() {
    }

    public BdbGroupFlowCtrlEntity(String flowCtrlInfo, int statusId, int ruleCnt, int qryPriorityId, String attributes, boolean curNeedSSDProc, String modifyUser, Date modifyDate) {
        this.statusId = statusId;
        this.groupName = "default_master_ctrl";
        this.serialId = System.currentTimeMillis();
        this.flowCtrlInfo = flowCtrlInfo;
        this.attributes = attributes;
        this.ruleCnt = ruleCnt;
        this.ssdTranslateId = System.currentTimeMillis();
        this.needSSDProc = curNeedSSDProc;
        this.createUser = modifyUser;
        this.createDate = modifyDate;
        this.setQryPriorityId(qryPriorityId);
    }

    public BdbGroupFlowCtrlEntity(String groupName, String flowCtrlInfo, int statusId, int ruleCnt, int qryPriorityId, String attributes, boolean needSSDProc, String modifyUser, Date modifyDate) {
        this.groupName = groupName;
        this.serialId = System.currentTimeMillis();
        this.statusId = statusId;
        this.flowCtrlInfo = flowCtrlInfo;
        this.attributes = attributes;
        this.ruleCnt = ruleCnt;
        this.createUser = modifyUser;
        this.createDate = modifyDate;
        this.needSSDProc = needSSDProc;
        this.ssdTranslateId = -2L;
        this.setQryPriorityId(qryPriorityId);
    }

    public BdbGroupFlowCtrlEntity(String groupName, String flowCtrlInfo, int statusId, int ruleCnt, String attributes, long ssdTranslateId, boolean needSSDProc, String modifyUser, Date modifyDate) {
        this.groupName = groupName;
        this.serialId = System.currentTimeMillis();
        this.statusId = statusId;
        this.flowCtrlInfo = flowCtrlInfo;
        this.attributes = attributes;
        this.ruleCnt = ruleCnt;
        this.createUser = modifyUser;
        this.createDate = modifyDate;
        this.needSSDProc = needSSDProc;
        this.ssdTranslateId = ssdTranslateId;
    }

    public BdbGroupFlowCtrlEntity(long serialId, String groupName, String flowCtrlInfo, int statusId, int ruleCnt, int qryPriorityId, String attributes, String modifyUser, Date modifyDate) {
        this.groupName = groupName;
        this.serialId = serialId;
        this.statusId = statusId;
        this.flowCtrlInfo = flowCtrlInfo;
        this.attributes = attributes;
        this.ruleCnt = ruleCnt;
        this.createUser = modifyUser;
        this.createDate = modifyDate;
        this.needSSDProc = false;
        this.ssdTranslateId = -2L;
        this.setQryPriorityId(qryPriorityId);
    }

    public long getSsdTranslateId() {
        return this.ssdTranslateId;
    }

    public int getRuleCnt() {
        return this.ruleCnt;
    }

    public void setRuleCnt(int ruleCnt) {
        this.ruleCnt = ruleCnt;
    }

    public long getSerialId() {
        return this.serialId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }

    public String getModifyUser() {
        return this.createUser;
    }

    public boolean isNeedSSDProc() {
        return this.needSSDProc;
    }

    public void setNeedSSDProc(boolean needSSDProc) {
        this.needSSDProc = needSSDProc;
    }

    public Date getModifyDate() {
        return this.createDate;
    }

    public String getFlowCtrlInfo() {
        return this.flowCtrlInfo;
    }

    public void setFlowCtrlInfo(int ruleCnt, String flowCtrlInfo) {
        this.ruleCnt = ruleCnt;
        this.flowCtrlInfo = flowCtrlInfo;
        this.serialId = System.currentTimeMillis();
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int statusId) {
        this.statusId = statusId;
        this.serialId = System.currentTimeMillis();
    }

    public boolean isValidStatus() {
        return this.statusId != 0;
    }

    public int getQryPriorityId() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"qryPriorityId");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return 0;
    }

    public void setQryPriorityId(int qryPriorityId) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"qryPriorityId", (String)String.valueOf(qryPriorityId));
    }

    public EnableStatus getResCheckStatus() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"resChkStatusId");
        if (atrVal != null) {
            return EnableStatus.valueOf(Integer.parseInt(atrVal));
        }
        return EnableStatus.STATUS_UNDEFINE;
    }

    public void setResCheckStatus(EnableStatus resCheckStatus) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"resChkStatusId", (String)String.valueOf(resCheckStatus.getCode()));
    }

    public int getAllowedBrokerClientRate() {
        String atrVal = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"resBrokerClientRate");
        if (atrVal != null) {
            return Integer.parseInt(atrVal);
        }
        return -2;
    }

    public void setAllowedBrokerClientRate(int allowedBrokerClientRate) {
        this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"resBrokerClientRate", (String)String.valueOf(allowedBrokerClientRate));
    }

    public void setCreateInfo(String createUser, Date createDate) {
        if (TStringUtils.isNotBlank((String)createUser)) {
            this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"creater", (String)createUser);
        }
        if (createDate != null) {
            String dataStr = DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)createDate);
            this.attributes = TStringUtils.setAttrValToAttributes((String)this.attributes, (String)"createDate", (String)dataStr);
        }
    }

    public String getCreateUser() {
        String tmpCreateUser = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"creater");
        if (TStringUtils.isEmpty((String)tmpCreateUser)) {
            tmpCreateUser = this.createUser;
        }
        return tmpCreateUser;
    }

    public Date getCreateDate() {
        String dateStr = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"createDate");
        if (TStringUtils.isNotEmpty((String)dateStr)) {
            return DateTimeConvertUtils.yyyyMMddHHmmss2date((String)dateStr);
        }
        return this.createDate;
    }

    public String getStrModifyDate() {
        return DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.createDate);
    }

    public String getStrCreateDate() {
        String dateStr = TStringUtils.getAttrValFrmAttributes((String)this.attributes, (String)"createDate");
        if (TStringUtils.isEmpty((String)dateStr)) {
            dateStr = DateTimeConvertUtils.date2yyyyMMddHHmmss((Date)this.createDate);
        }
        return dateStr;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("groupName", (Object)this.groupName).append("serialId", this.serialId).append("statusId", this.statusId).append("flowCtrlInfo", (Object)".....").append("ruleCnt", this.ruleCnt).append("ssdTranslateId", this.ssdTranslateId).append("needSSDProc", this.needSSDProc).append("attributes", (Object)this.attributes).append("createUser", (Object)this.getCreateUser()).append("createDate", (Object)this.getCreateUser()).append("modifyUser", (Object)this.getModifyUser()).append("modifyDate", (Object)this.getStrModifyDate()).toString();
    }

    public StringBuilder toJsonString(StringBuilder sBuilder) {
        return sBuilder.append("{\"type\":\"BdbGroupFlowCtrlEntity\",").append("\"groupName\":\"").append(this.groupName).append("\",\"statusId\":").append(this.statusId).append(",\"ssdTranslateId\":").append(this.ssdTranslateId).append(",\"ruleCnt\":").append(this.ruleCnt).append(",\"needSSDProc\":").append(this.needSSDProc).append(",\"serialId\":").append(this.serialId).append(",\"qryPriorityId\":").append(this.getQryPriorityId()).append(",\"flowCtrlInfo\":").append(this.flowCtrlInfo).append(", \"attributes\":\"").append(this.attributes).append(",\"createUser\":\"").append(this.getCreateUser()).append("\",\"createDate\":\"").append(this.getStrCreateDate()).append("\",\"modifyUser\":\"").append(this.getModifyUser()).append("\",\"modifyDate\":\"").append(this.getStrModifyDate()).append("\"}");
    }
}

