/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodebroker;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.utils.CheckSum;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corebase.utils.Tuple4;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerSyncData {
    private static final Logger logger = LoggerFactory.getLogger(BrokerSyncData.class);
    private long dataPushId;
    private final AtomicLong syncDownDataConfId = new AtomicLong(System.currentTimeMillis());
    private int syncDownDataChkSumId;
    private ManageStatus mngStatus;
    private String syncDownBrokerConfInfo;
    private Map<String, String> syncDownTopicConfInfoMap = new HashMap<String, String>();
    private boolean isStatusChanged = false;
    private boolean isConfChanged = false;
    private long syncUpDataConfId = -2L;
    private int syncUpDataChkSumId = -2;
    private String syncUpBrokerConfInfo;
    private List<String> syncUpTopicConfInfos = new ArrayList<String>();
    Map<String, TopicInfo> syncUpTopicInfoMap = new HashMap<String, TopicInfo>();
    private long lastDataUpTime = 0L;

    public Tuple2<Boolean, Boolean> updBrokerSyncData(boolean isForceSync, long dataPushId, ManageStatus mngStatus, String brokerConfInfo, Map<String, String> topicConfInfoMap) {
        this.isStatusChanged = false;
        this.isConfChanged = false;
        if (TStringUtils.isBlank((String)brokerConfInfo)) {
            return null;
        }
        this.dataPushId = dataPushId;
        if (isForceSync || this.mngStatus != mngStatus) {
            this.mngStatus = mngStatus;
            this.isStatusChanged = true;
        }
        if (isForceSync || this.isSyncDataChanged(brokerConfInfo, topicConfInfoMap)) {
            this.syncDownBrokerConfInfo = brokerConfInfo;
            this.syncDownTopicConfInfoMap = topicConfInfoMap == null ? new HashMap<String, String>() : topicConfInfoMap;
            this.syncDownDataChkSumId = this.calculateConfigCrc32Value(this.syncDownBrokerConfInfo, this.syncDownTopicConfInfoMap);
            this.isConfChanged = true;
        }
        if (this.isStatusChanged && this.isConfChanged) {
            this.syncDownDataConfId.incrementAndGet();
        }
        return new Tuple2((Object)this.isStatusChanged, (Object)this.isConfChanged);
    }

    public boolean bookBrokerReportInfo(BrokerInfo brokerInfo, long syncDataConfId, int syncDataChkSumId, boolean isTakeData, String syncBrokerConfInfo, List<String> syncTopicConfInfos) {
        this.syncUpDataConfId = syncDataConfId;
        this.syncUpDataChkSumId = syncDataChkSumId;
        if (isTakeData) {
            this.syncUpBrokerConfInfo = syncBrokerConfInfo;
            this.syncUpTopicConfInfos = syncTopicConfInfos == null ? new ArrayList<String>() : syncTopicConfInfos;
            Map<String, TopicInfo> tmpInfoMap = this.parseTopicInfoConf(brokerInfo);
            if (tmpInfoMap == null) {
                this.syncUpTopicInfoMap.clear();
            } else {
                this.syncUpTopicInfoMap = tmpInfoMap;
            }
            this.lastDataUpTime = System.currentTimeMillis();
        }
        return this.isConfSynchronized();
    }

    public boolean isConfSynchronized() {
        return this.syncDownDataConfId.get() == this.syncUpDataConfId && this.syncDownDataChkSumId == this.syncUpDataChkSumId;
    }

    public boolean isDownTopicConfEmpty() {
        return this.syncDownTopicConfInfoMap.isEmpty();
    }

    public Tuple4<Long, Integer, String, List<String>> getBrokerSyncData() {
        if (this.isConfSynchronized()) {
            return new Tuple4((Object)this.syncDownDataConfId.get(), (Object)this.syncDownDataChkSumId, null, null);
        }
        ArrayList<String> topicInfoList = new ArrayList<String>();
        for (String topicInfo : this.syncDownTopicConfInfoMap.values()) {
            if (topicInfo == null) continue;
            topicInfoList.add(topicInfo);
        }
        return new Tuple4((Object)this.syncDownDataConfId.get(), (Object)this.syncDownDataChkSumId, (Object)this.syncDownBrokerConfInfo, topicInfoList);
    }

    public Tuple2<ManageStatus, Map<String, TopicInfo>> getBrokerPublishInfo() {
        return new Tuple2((Object)this.mngStatus, this.syncUpTopicInfoMap);
    }

    public long getDataPushId() {
        return this.dataPushId;
    }

    public long getLastDataReportTime() {
        return this.lastDataUpTime;
    }

    private boolean isSyncDataChanged(String brokerConfInfo, Map<String, String> topicConfInfoMap) {
        return !Objects.equals(this.syncDownBrokerConfInfo, brokerConfInfo) || !Objects.equals(this.syncDownTopicConfInfoMap, topicConfInfoMap);
    }

    public StringBuilder toJsonString(StringBuilder sBuffer) {
        sBuffer.append("{\"dataPushId\":").append(this.dataPushId).append(",\"mngStatus\":\"").append(this.mngStatus.getDescription()).append("\",\"syncDownDataConfId\":").append(this.syncDownDataConfId.get()).append(",\"syncDownDataChkSumId\":").append(this.syncDownDataChkSumId).append(",\"isStatusChanged\":").append(this.isStatusChanged).append(",\"isConfChanged\":").append(this.isConfChanged).append(",\"syncDownBrokerConfInfo\":\"").append(this.syncDownBrokerConfInfo).append("\",\"syncDownTopicConfInfoMap\":\"").append(this.syncDownTopicConfInfoMap.toString()).append("\",\"syncUpDataConfId\":").append(this.syncUpDataConfId).append(",\"syncUpDataChkSumId\":").append(this.syncUpDataChkSumId).append(",\"syncUpBrokerConfInfo\":\"").append(this.syncUpBrokerConfInfo).append("\",\"syncUpTopicConfInfos\":\"").append(this.syncUpTopicConfInfos.toString()).append("\",\"syncUpTopicInfoMap\":\"").append(this.syncUpTopicInfoMap.toString()).append("\",\"lastDataUpTime\":").append(this.lastDataUpTime).append("}");
        return sBuffer;
    }

    private Map<String, TopicInfo> parseTopicInfoConf(BrokerInfo brokerInfo) {
        if (TStringUtils.isBlank((String)this.syncUpBrokerConfInfo)) {
            return null;
        }
        String[] brokerConfInfoAttrs = this.syncUpBrokerConfInfo.split(":");
        int numPartitions = Integer.parseInt(brokerConfInfoAttrs[0]);
        boolean cfgAcceptPublish = Boolean.parseBoolean(brokerConfInfoAttrs[1]);
        boolean cfgAcceptSubscribe = Boolean.parseBoolean(brokerConfInfoAttrs[2]);
        int numTopicStores = 1;
        if (brokerConfInfoAttrs.length > 7 && !TStringUtils.isBlank((String)brokerConfInfoAttrs[7])) {
            numTopicStores = Integer.parseInt(brokerConfInfoAttrs[7]);
        }
        HashMap<String, TopicInfo> topicInfoMap = new HashMap<String, TopicInfo>();
        for (String strTopicConfInfo : this.syncUpTopicConfInfos) {
            if (TStringUtils.isBlank((String)strTopicConfInfo)) continue;
            String[] topicConfAttrs = strTopicConfInfo.split(":");
            String tmpTopic = topicConfAttrs[0];
            int tmpPartNum = numPartitions;
            if (!TStringUtils.isBlank((String)topicConfAttrs[1])) {
                tmpPartNum = Integer.parseInt(topicConfAttrs[1]);
            }
            boolean tmpAcceptPublish = cfgAcceptPublish;
            if (!TStringUtils.isBlank((String)topicConfAttrs[2])) {
                tmpAcceptPublish = Boolean.parseBoolean(topicConfAttrs[2]);
            }
            int tmpNumTopicStores = numTopicStores;
            if (!TStringUtils.isBlank((String)topicConfAttrs[8])) {
                tmpNumTopicStores = Integer.parseInt(topicConfAttrs[8]);
                tmpNumTopicStores = tmpNumTopicStores > 0 ? tmpNumTopicStores : numTopicStores;
            }
            boolean tmpAcceptSubscribe = cfgAcceptSubscribe;
            if (!TStringUtils.isBlank((String)topicConfAttrs[3])) {
                tmpAcceptSubscribe = Boolean.parseBoolean(topicConfAttrs[3]);
            }
            topicInfoMap.put(tmpTopic, new TopicInfo(brokerInfo, tmpTopic, tmpPartNum, tmpNumTopicStores, tmpAcceptPublish, tmpAcceptSubscribe));
        }
        return topicInfoMap;
    }

    private int calculateConfigCrc32Value(String brokerConfInfo, Map<String, String> topicConfInfoMap) {
        int result = -1;
        int capacity = 0;
        ArrayList<String> topicConfInfoLst = new ArrayList<String>(topicConfInfoMap.values());
        Collections.sort(topicConfInfoLst);
        capacity += brokerConfInfo.length();
        for (String itemStr : topicConfInfoLst) {
            capacity += itemStr.length();
        }
        capacity *= 2;
        for (int i = 1; i < 3; ++i) {
            result = this.inCalcBufferResult(capacity, brokerConfInfo, topicConfInfoLst);
            if (result >= 0) {
                return result;
            }
            capacity *= i + 1;
        }
        logger.error("Calculate the CRC32 value of Broker Configure error!");
        return 0;
    }

    private int inCalcBufferResult(int capacity, String brokerConfInfo, List<String> topicConfInfoLst) {
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.put(StringUtils.getBytesUtf8((String)brokerConfInfo));
        for (String itemStr : topicConfInfoLst) {
            byte[] itemData = StringUtils.getBytesUtf8((String)itemStr);
            if (itemData.length > buffer.remaining()) {
                return -1;
            }
            buffer.put(itemData);
        }
        return CheckSum.crc32((byte[])buffer.array());
    }
}

