/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.sort.cls.SortClsClusterInfo;
import org.apache.inlong.manager.pojo.cluster.sort.es.SortEsClusterInfo;
import org.apache.inlong.manager.pojo.cluster.sort.http.SortHttpClusterInfo;
import org.apache.inlong.manager.pojo.cluster.sort.kafka.SortKafkaClusterInfo;
import org.apache.inlong.manager.pojo.cluster.sort.pulsar.SortPulsarClusterInfo;
import org.apache.inlong.manager.pojo.sort.BaseSortClusterDTO;
import org.apache.inlong.manager.pojo.sort.BaseSortClusterRequest;
import org.apache.inlong.manager.service.cluster.AbstractClusterOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SortClusterOperator
extends AbstractClusterOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortClusterOperator.class);
    private static final Set<String> SORT_CLUSTER_SET = new HashSet<String>(){
        {
            this.add("SORT_HTTP");
            this.add("SORT_CLS");
            this.add("SORT_PULSAR");
            this.add("SORT_ES");
            this.add("SORT_KAFKA");
        }
    };
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String clusterType) {
        return SORT_CLUSTER_SET.contains(clusterType);
    }

    @Override
    protected void setTargetEntity(ClusterRequest request, InlongClusterEntity targetEntity) {
        BaseSortClusterRequest clusterRequest = (BaseSortClusterRequest)request;
        CommonBeanUtils.copyProperties((Object)clusterRequest, (Object)targetEntity, (boolean)true);
        try {
            BaseSortClusterDTO dto = BaseSortClusterDTO.getFromRequest((BaseSortClusterRequest)clusterRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            LOGGER.info("success to set entity for sort cluster");
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    @Override
    public ClusterInfo getFromEntity(InlongClusterEntity entity) {
        SortHttpClusterInfo sortClusterInfo;
        Preconditions.expectNotNull((Object)entity, (String)ErrorCodeEnum.CLUSTER_NOT_FOUND.getMessage());
        switch (entity.getType()) {
            case "SORT_HTTP": {
                sortClusterInfo = new SortHttpClusterInfo();
                break;
            }
            case "SORT_CLS": {
                sortClusterInfo = new SortClsClusterInfo();
                break;
            }
            case "SORT_PULSAR": {
                sortClusterInfo = new SortPulsarClusterInfo();
                break;
            }
            case "SORT_ES": {
                sortClusterInfo = new SortEsClusterInfo();
                break;
            }
            case "SORT_KAFKA": {
                sortClusterInfo = new SortKafkaClusterInfo();
                break;
            }
            default: {
                throw new BusinessException("unsupported cluster type " + entity.getType());
            }
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)sortClusterInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            BaseSortClusterDTO dto = BaseSortClusterDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)sortClusterInfo);
        }
        return sortClusterInfo;
    }
}

