/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.dirtyData.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.dao.entity.DirtyQueryLogEntity;
import org.apache.inlong.manager.dao.mapper.DirtyQueryLogEntityMapper;
import org.apache.inlong.manager.pojo.sink.DirtyDataDetailResponse;
import org.apache.inlong.manager.pojo.sink.DirtyDataRequest;
import org.apache.inlong.manager.pojo.sink.DirtyDataResponse;
import org.apache.inlong.manager.pojo.sink.DirtyDataTrendDetailResponse;
import org.apache.inlong.manager.pojo.sink.DirtyDataTrendRequest;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.dirtyData.DirtyQueryLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DirtyQueryLogServiceImpl
implements DirtyQueryLogService {
    private static final Logger log = LoggerFactory.getLogger(DirtyQueryLogServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DirtyQueryLogServiceImpl.class);
    @Autowired
    private DirtyQueryLogEntityMapper dirtyQueryLogEntityMapper;
    @Autowired
    private ObjectMapper objectMapper;
    @Value(value="${dirty.log.clean.enabled:false}")
    private Boolean dirtyLogCleanEnabled;
    @Value(value="${dirty.log.clean.interval.minutes:5}")
    private Integer dirtyLogCleanInterval;
    @Value(value="${dirty.log.retention.minutes:10}")
    private Integer retentionMinutes;
    @Value(value="${dirty.log.db.table:inlong_iceberg::dirty_data_achive_iceberg}")
    private String dirtyDataDbTable;

    @PostConstruct
    private void startDirtyLogCleanTask() {
        if (this.dirtyLogCleanEnabled.booleanValue()) {
            ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("scheduled-dirtyQueryLog-deleted-%d").setDaemon(true).build();
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(factory);
            executor.scheduleWithFixedDelay(() -> {
                try {
                    LOGGER.info("begin to clean dirty query log");
                    this.dirtyQueryLogEntityMapper.updateToTimeout(this.retentionMinutes);
                    LOGGER.info("success to clean dirty query log successfully");
                }
                catch (Throwable t) {
                    LOGGER.error("clean dirty query log error", t);
                }
            }, 0L, this.dirtyLogCleanInterval.intValue(), TimeUnit.MINUTES);
            LOGGER.info("clean dirty query log started successfully");
        }
    }

    @Override
    public DirtyDataResponse listDirtyDataTrend(DirtyDataTrendRequest request) {
        if (CollectionUtils.isEmpty((Collection)request.getSinkIdList())) {
            return null;
        }
        try {
            DirtyDataResponse dirtyDataResponse = new DirtyDataResponse();
            String requestStr = this.objectMapper.writeValueAsString((Object)request);
            String md5 = DigestUtils.md5Hex((String)requestStr);
            DirtyQueryLogEntity dirtyQueryLogEntity = this.dirtyQueryLogEntityMapper.selectByMd5(md5);
            if (dirtyQueryLogEntity != null) {
                LOGGER.info("dirty query log is exist");
                dirtyDataResponse.setTaskId(dirtyQueryLogEntity.getTaskId());
                return dirtyDataResponse;
            }
            DirtyQueryLogEntity dirtyQueryLog = new DirtyQueryLogEntity();
            dirtyQueryLog.setMd5(md5);
            dirtyQueryLog.setRequestParams(requestStr);
            dirtyQueryLog.setCreator(LoginUserUtils.getLoginUser().getName());
            dirtyQueryLog.setModifier(LoginUserUtils.getLoginUser().getName());
            this.dirtyQueryLogEntityMapper.insert(dirtyQueryLog);
            return dirtyDataResponse;
        }
        catch (Exception e) {
            throw new BusinessException("list dirty data trend failed");
        }
    }

    @Override
    public DirtyDataResponse listDirtyData(DirtyDataRequest request) {
        if (CollectionUtils.isEmpty((Collection)request.getSinkIdList())) {
            return null;
        }
        if (request.getDataCount() == null) {
            request.setDataCount(Integer.valueOf(10));
        }
        try {
            DirtyDataResponse dirtyDataResponse = new DirtyDataResponse();
            String requestStr = this.objectMapper.writeValueAsString((Object)request);
            String md5 = DigestUtils.md5Hex((String)requestStr);
            DirtyQueryLogEntity dirtyQueryLogEntity = this.dirtyQueryLogEntityMapper.selectByMd5(md5);
            if (dirtyQueryLogEntity != null) {
                LOGGER.info("dirty query log is exist");
                dirtyDataResponse.setTaskId(dirtyQueryLogEntity.getTaskId());
                return dirtyDataResponse;
            }
            DirtyQueryLogEntity dirtyQueryLog = new DirtyQueryLogEntity();
            dirtyQueryLog.setMd5(md5);
            dirtyQueryLog.setRequestParams(requestStr);
            dirtyQueryLog.setCreator(LoginUserUtils.getLoginUser().getName());
            dirtyQueryLog.setModifier(LoginUserUtils.getLoginUser().getName());
            this.dirtyQueryLogEntityMapper.insert(dirtyQueryLog);
            return dirtyDataResponse;
        }
        catch (Exception e) {
            LOGGER.error("list dirty data failed", (Throwable)e);
            throw new BusinessException("list dirty data failed");
        }
    }

    @Override
    public List<DirtyDataDetailResponse> getDirtyData(String taskId) {
        try {
            return new ArrayList<DirtyDataDetailResponse>();
        }
        catch (Exception e) {
            LOGGER.error("get dirty data failed", (Throwable)e);
            throw new BusinessException("get dirty data failed");
        }
    }

    @Override
    public List<DirtyDataTrendDetailResponse> getDirtyDataTrend(String taskId) {
        try {
            return new ArrayList<DirtyDataTrendDetailResponse>();
        }
        catch (Exception e) {
            LOGGER.error("get dirty data trend failed", (Throwable)e);
            throw new BusinessException("get dirty data trend failed");
        }
    }

    @Override
    public String getSqlTaskStatus(String taskId) {
        try {
            return "success";
        }
        catch (Exception e) {
            LOGGER.error("get sql task status failed", (Throwable)e);
            throw new BusinessException("get get sql task status failed");
        }
    }
}

