/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.kudu;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.kudu.KuduColumnInfo;
import org.apache.inlong.manager.pojo.sink.kudu.KuduTableInfo;
import org.apache.inlong.manager.pojo.sink.kudu.KuduType;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ListTablesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduResourceClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(KuduResourceClient.class);
    private static final String PARTITION_STRATEGY_HASH = "HASH";
    private static final String PARTITION_STRATEGY_PRIMARY_KEY = "PrimaryKey";
    private static final int DEFAULT_BUCKETS = 6;
    private final KuduClient client;

    public KuduResourceClient(String kuduMaster) {
        this.client = new KuduClient.KuduClientBuilder(kuduMaster).build();
    }

    public boolean tableExist(String tableName) throws KuduException {
        return this.client.tableExists(tableName);
    }

    public void createTable(String tableName, KuduTableInfo tableInfo) throws KuduException {
        List columns = tableInfo.getColumns();
        List kuduColumns = columns.stream().sorted(Comparator.comparing(KuduColumnInfo::getPartitionStrategy)).map(this::buildColumnSchema).collect(Collectors.toList());
        Schema schema = new Schema(kuduColumns);
        CreateTableOptions options = new CreateTableOptions();
        List parCols = columns.stream().filter(column -> PARTITION_STRATEGY_HASH.equalsIgnoreCase(column.getPartitionStrategy())).map(SinkField::getFieldName).collect(Collectors.toList());
        if (!parCols.isEmpty()) {
            Integer partitionNum = tableInfo.getBuckets();
            int buckets = partitionNum == null ? 6 : partitionNum;
            options.addHashPartitions(parCols, buckets);
        }
        this.client.createTable(tableName, schema, options);
    }

    private ColumnSchema buildColumnSchema(KuduColumnInfo columnInfo) {
        String name = columnInfo.getFieldName();
        String type = columnInfo.getFieldType();
        String desc = columnInfo.getFieldComment();
        String kuduType = KuduType.forType((String)type).kuduType();
        Type typeForName = Type.getTypeForName((String)kuduType);
        String partitionStrategy = columnInfo.getPartitionStrategy();
        ColumnSchema.ColumnSchemaBuilder builder = new ColumnSchema.ColumnSchemaBuilder(name, typeForName).comment(desc);
        if (PARTITION_STRATEGY_HASH.equalsIgnoreCase(partitionStrategy) || PARTITION_STRATEGY_PRIMARY_KEY.equalsIgnoreCase(partitionStrategy)) {
            builder.key(true);
        } else {
            builder.nullable(true);
        }
        return builder.build();
    }

    private ColumnSchema buildColumnSchema(String name, String desc, Type typeForName) {
        ColumnSchema.ColumnSchemaBuilder builder = new ColumnSchema.ColumnSchemaBuilder(name, typeForName).comment(desc).nullable(true);
        return builder.build();
    }

    public List<KuduColumnInfo> getColumns(String tableName) throws KuduException {
        KuduTable kuduTable = this.client.openTable(tableName);
        List columns = kuduTable.getSchema().getColumns();
        return columns.stream().map(columnSchema -> {
            String comment = columnSchema.getComment();
            Type type = columnSchema.getType();
            String name = columnSchema.getName();
            String javaType = KuduType.forKuduType((String)type.getName()).getType();
            KuduColumnInfo columnInfo = new KuduColumnInfo();
            columnInfo.setFieldName(name);
            columnInfo.setFieldType(javaType);
            columnInfo.setFieldComment(comment);
            return columnInfo;
        }).collect(Collectors.toList());
    }

    public void addColumns(String tableName, List<KuduColumnInfo> needAddColumns) throws KuduException {
        KuduTable table = this.client.openTable(tableName);
        AlterTableOptions alterOptions = new AlterTableOptions();
        for (KuduColumnInfo columnInfo : needAddColumns) {
            String name = columnInfo.getFieldName();
            String type = columnInfo.getFieldType();
            String desc = columnInfo.getFieldComment();
            String kuduType = KuduType.forType((String)type).kuduType();
            Type typeForName = Type.getTypeForName((String)kuduType);
            ColumnSchema columnSchema = this.buildColumnSchema(name, desc, typeForName);
            alterOptions.addColumn(columnSchema);
        }
        this.client.alterTable(table.getName(), alterOptions);
    }

    public List<String> getTablesList() throws KuduException {
        ListTablesResponse tablesList = this.client.getTablesList();
        return tablesList.getTablesList();
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (KuduException e) {
            LOG.error("Can not properly close kuduClient.", (Throwable)e);
        }
    }
}

