/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.common.enums.TaskStateEnum;
import org.apache.inlong.common.enums.TaskTypeEnum;
import org.apache.inlong.common.pojo.agent.AgentConfigInfo;
import org.apache.inlong.common.pojo.agent.AgentResponseCode;
import org.apache.inlong.common.pojo.agent.CmdConfig;
import org.apache.inlong.common.pojo.agent.DataConfig;
import org.apache.inlong.common.pojo.agent.TaskResult;
import org.apache.inlong.common.pojo.dataproxy.DataProxyTopicInfo;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.consts.SourceType;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.AgentTaskConfigEntity;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamFieldEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceFieldEntity;
import org.apache.inlong.manager.dao.mapper.AgentTaskConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.DataSourceCmdConfigEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceFieldEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterPageRequest;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterDTO;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarDTO;
import org.apache.inlong.manager.pojo.source.DataAddTaskRequest;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.InlongStreamExtParam;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.node.DataNodeService;
import org.apache.inlong.manager.service.source.SourceOperatorFactory;
import org.apache.inlong.manager.service.source.StreamSourceOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractSourceOperator
implements StreamSourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSourceOperator.class);
    private static final Gson GSON = new Gson();
    private static final int MODULUS_100 = 100;
    @Autowired
    protected StreamSourceEntityMapper sourceMapper;
    @Autowired
    protected StreamSourceFieldEntityMapper sourceFieldMapper;
    @Autowired
    protected InlongStreamFieldEntityMapper streamFieldMapper;
    @Autowired
    protected DataNodeService dataNodeService;
    @Autowired
    private AgentTaskConfigEntityMapper agentTaskConfigEntityMapper;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongClusterEntityMapper clusterMapper;
    @Autowired
    private DataSourceCmdConfigEntityMapper sourceCmdConfigMapper;
    @Autowired
    private InlongStreamEntityMapper streamMapper;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private AutowireCapableBeanFactory autowireCapableBeanFactory;
    private SourceOperatorFactory operatorFactory;

    protected abstract String getSourceType();

    protected abstract void setTargetEntity(SourceRequest var1, StreamSourceEntity var2);

    @Override
    public String getExtParams(StreamSourceEntity sourceEntity) {
        return sourceEntity.getExtParams();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer saveOpt(SourceRequest request, Integer streamStatus, String operator) {
        StreamSourceEntity entity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        if ("AUTO_PUSH".equals(request.getSourceType())) {
            entity.setStatus(SourceStatus.SOURCE_NORMAL.getCode());
        } else if (StreamStatus.forCode((int)streamStatus).equals((Object)StreamStatus.CONFIG_SUCCESSFUL)) {
            entity.setStatus(SourceStatus.TO_BE_ISSUED_ADD.getCode());
        } else {
            entity.setStatus(SourceStatus.SOURCE_NEW.getCode());
        }
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.setTargetEntity(request, entity);
        this.sourceMapper.insert(entity);
        this.saveFieldOpt(entity, request.getFieldList());
        if (request.getEnableSyncSchema().booleanValue()) {
            this.syncSourceFieldInfo(request, operator);
        }
        if (StreamStatus.forCode((int)streamStatus).equals((Object)StreamStatus.CONFIG_SUCCESSFUL)) {
            this.updateAgentTaskConfig(request, operator);
        }
        return entity.getId();
    }

    @Override
    public List<StreamField> getSourceFields(Integer sourceId) {
        List sourceFieldEntities = this.sourceFieldMapper.selectBySourceId(sourceId);
        return CommonBeanUtils.copyListProperties((List)sourceFieldEntities, StreamField::new);
    }

    @Override
    public PageResult<? extends StreamSource> getPageInfo(Page<StreamSourceEntity> entityPage) {
        if (CollectionUtils.isEmpty(entityPage)) {
            return PageResult.empty();
        }
        return PageResult.fromPage(entityPage).map(this::getFromEntity);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(SourceRequest request, Integer streamStatus, Integer groupMode, String operator) {
        int rowCount;
        boolean allowUpdate;
        StreamSourceEntity entity = this.sourceMapper.selectByIdForUpdate(request.getId());
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_NOT_FOUND, String.format("not found source record by id=%d", request.getId()));
        }
        if ("AUTO_PUSH".equals(entity.getSourceType())) {
            this.updateFieldOpt(entity, request.getFieldList());
            return;
        }
        boolean bl = allowUpdate = InlongConstants.DATASYNC_REALTIME_MODE.equals(groupMode) || InlongConstants.DATASYNC_OFFLINE_MODE.equals(groupMode) || SourceStatus.ALLOWED_UPDATE.contains(entity.getStatus());
        if (!allowUpdate) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_OPT_NOT_ALLOWED, String.format("source=%s is not allowed to update, please wait until its changed to final status or stop / frozen / delete it firstly", entity));
        }
        String errMsg = String.format("source has already updated with groupId=%s, streamId=%s, name=%s, curVersion=%s", request.getInlongGroupId(), request.getInlongStreamId(), request.getSourceName(), request.getVersion());
        if (!Objects.equals(entity.getVersion(), request.getVersion())) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, errMsg);
        }
        if (!Objects.equals(entity.getSourceType(), request.getSourceType())) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, String.format("source type=%s cannot change to %s", entity.getSourceType(), request.getSourceType()));
        }
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        String sourceName = request.getSourceName();
        List sourceList = this.sourceMapper.selectByRelatedId(groupId, streamId, sourceName);
        for (StreamSourceEntity sourceEntity : sourceList) {
            Integer sourceId = sourceEntity.getId();
            if (Objects.equals(sourceId, request.getId())) continue;
            throw new BusinessException(ErrorCodeEnum.SOURCE_ALREADY_EXISTS, String.format("source name=%s already exists with the groupId=%s streamId=%s", sourceName, groupId, streamId));
        }
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        entity.setPreviousStatus(entity.getStatus());
        if (InlongConstants.STANDARD_MODE.equals(groupMode)) {
            SourceStatus sourceStatus = SourceStatus.forCode((int)entity.getStatus());
            Integer nextStatus = entity.getStatus();
            if (StreamStatus.forCode((int)streamStatus).equals((Object)StreamStatus.CONFIG_SUCCESSFUL)) {
                nextStatus = SourceStatus.TO_BE_ISSUED_RETRY.getCode();
            } else {
                switch (SourceStatus.forCode((int)entity.getStatus())) {
                    case SOURCE_NORMAL: 
                    case HEARTBEAT_TIMEOUT: {
                        nextStatus = SourceStatus.TO_BE_ISSUED_RETRY.getCode();
                        break;
                    }
                    case SOURCE_FAILED: {
                        nextStatus = SourceStatus.SOURCE_NEW.getCode();
                        break;
                    }
                }
            }
            entity.setStatus(nextStatus);
        }
        if ((rowCount = this.sourceMapper.updateByPrimaryKeySelective(entity)) != InlongConstants.AFFECTED_ONE_ROW) {
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED, errMsg);
        }
        this.updateFieldOpt(entity, request.getFieldList());
        LOGGER.debug("success to update source of type={}", (Object)request.getSourceType());
        if (StreamStatus.forCode((int)streamStatus).equals((Object)StreamStatus.CONFIG_SUCCESSFUL)) {
            this.updateAgentTaskConfig(request, operator);
        }
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void stopOpt(SourceRequest request, String operator) {
        StreamSourceEntity existEntity = this.sourceMapper.selectByIdForUpdate(request.getId());
        SourceStatus curState = SourceStatus.forCode((int)existEntity.getStatus());
        SourceStatus nextState = SourceStatus.TO_BE_ISSUED_STOP;
        if (curState == SourceStatus.SOURCE_STOP) {
            return;
        }
        StreamSourceEntity curEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        curEntity.setPreviousStatus(curState.getCode());
        curEntity.setStatus(nextState.getCode());
        int rowCount = this.sourceMapper.updateByPrimaryKeySelective(curEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("source has already updated with groupId={}, streamId={}, name={}, curVersion={}", new Object[]{curEntity.getInlongGroupId(), curEntity.getInlongStreamId(), curEntity.getSourceName(), curEntity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        this.updateAgentTaskConfig(request, operator);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void restartOpt(SourceRequest request, String operator) {
        StreamSourceEntity existEntity = this.sourceMapper.selectByIdForUpdate(request.getId());
        SourceStatus curState = SourceStatus.forCode((int)existEntity.getStatus());
        SourceStatus nextState = SourceStatus.TO_BE_ISSUED_ACTIVE;
        StreamSourceEntity curEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        curEntity.setPreviousStatus(curState.getCode());
        curEntity.setStatus(nextState.getCode());
        int rowCount = this.sourceMapper.updateByPrimaryKeySelective(curEntity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("source has already updated with groupId={}, streamId={}, name={}, curVersion={}", new Object[]{curEntity.getInlongGroupId(), curEntity.getInlongStreamId(), curEntity.getSourceName(), curEntity.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
    }

    protected void updateFieldOpt(StreamSourceEntity entity, List<StreamField> fieldInfos) {
        Integer sourceId = entity.getId();
        if (CollectionUtils.isEmpty(fieldInfos)) {
            return;
        }
        this.sourceFieldMapper.deleteAll(sourceId);
        this.saveFieldOpt(entity, fieldInfos);
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        this.streamFieldMapper.deleteAllByIdentifier(groupId, streamId);
        this.saveStreamField(groupId, streamId, fieldInfos);
        LOGGER.debug("success to update source fields");
    }

    protected void saveStreamField(String groupId, String streamId, List<StreamField> infoList) {
        if (CollectionUtils.isEmpty(infoList)) {
            return;
        }
        infoList.forEach(streamField -> streamField.setId(null));
        List list = CommonBeanUtils.copyListProperties(infoList, InlongStreamFieldEntity::new);
        for (InlongStreamFieldEntity entity : list) {
            entity.setInlongGroupId(groupId);
            entity.setInlongStreamId(streamId);
            entity.setIsDeleted(InlongConstants.UN_DELETED);
        }
        this.streamFieldMapper.insertAll(list);
    }

    protected void saveFieldOpt(StreamSourceEntity entity, List<StreamField> fieldInfos) {
        LOGGER.debug("begin to save source fields={}", fieldInfos);
        if (CollectionUtils.isEmpty(fieldInfos)) {
            return;
        }
        int size = fieldInfos.size();
        ArrayList<StreamSourceFieldEntity> entityList = new ArrayList<StreamSourceFieldEntity>(size);
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        String sourceType = entity.getSourceType();
        Integer sourceId = entity.getId();
        for (StreamField fieldInfo : fieldInfos) {
            StreamSourceFieldEntity fieldEntity = (StreamSourceFieldEntity)CommonBeanUtils.copyProperties((Object)fieldInfo, StreamSourceFieldEntity::new);
            if (StringUtils.isEmpty((CharSequence)fieldEntity.getFieldComment())) {
                fieldEntity.setFieldComment(fieldEntity.getFieldName());
            }
            fieldEntity.setInlongGroupId(groupId);
            fieldEntity.setInlongStreamId(streamId);
            fieldEntity.setSourceId(sourceId);
            fieldEntity.setSourceType(sourceType);
            fieldEntity.setIsDeleted(InlongConstants.UN_DELETED);
            entityList.add(fieldEntity);
        }
        this.sourceFieldMapper.insertAll(entityList);
        LOGGER.debug("success to save source fields");
    }

    protected String getSerializationType(StreamSource streamSource, String streamDataType) {
        if (StringUtils.isNotBlank((CharSequence)streamSource.getSerializationType())) {
            return streamSource.getSerializationType();
        }
        return DataTypeEnum.forType((String)streamDataType).getType();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void syncSourceFieldInfo(SourceRequest request, String operator) {
        LOGGER.info("not support sync source field info for type ={}", (Object)request.getSourceType());
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public Integer addDataAddTask(DataAddTaskRequest request, String operator) {
        throw new BusinessException(String.format("not support data add task for type =%s", request.getSourceType()));
    }

    @Override
    public void updateAgentTaskConfig(SourceRequest request, String operator) {
        try {
            if ("AUTO_PUSH".equals(request.getSourceType())) {
                return;
            }
            String clusterName = request.getInlongClusterName();
            String ip = request.getAgentIp();
            String uuid = request.getUuid();
            if (StringUtils.isBlank((CharSequence)clusterName) || StringUtils.isBlank((CharSequence)ip)) {
                LOGGER.warn("skip update agent task config where cluster name or ip is null for request={}", (Object)request);
                return;
            }
            AgentTaskConfigEntity existEntity = this.agentTaskConfigEntityMapper.selectByIdentifier(ip, clusterName);
            AgentTaskConfigEntity agentTaskConfigEntity = new AgentTaskConfigEntity();
            if (existEntity != null) {
                agentTaskConfigEntity = (AgentTaskConfigEntity)CommonBeanUtils.copyProperties((Object)existEntity, AgentTaskConfigEntity::new, (boolean)true);
            }
            LOGGER.debug("begin to get agent config info for {}", (Object)request);
            HashSet<String> tagSet = new HashSet<String>(16);
            InlongClusterEntity agentClusterInfo = this.clusterMapper.selectByNameAndType(request.getInlongClusterName(), "AGENT");
            if (agentClusterInfo == null) {
                agentTaskConfigEntity.setIsDeleted(agentTaskConfigEntity.getId());
                this.agentTaskConfigEntityMapper.updateByIdSelective(agentTaskConfigEntity);
                return;
            }
            String clusterTag = agentClusterInfo.getClusterTags();
            AgentConfigInfo agentConfigInfo = AgentConfigInfo.builder().cluster(AgentConfigInfo.AgentClusterInfo.builder().parentId(agentClusterInfo.getId()).clusterName(agentClusterInfo.getName()).build()).build();
            if (StringUtils.isNotBlank((CharSequence)clusterTag)) {
                tagSet.addAll(Arrays.asList(clusterTag.split(",")));
                ArrayList clusterTagList = new ArrayList(tagSet);
                ClusterPageRequest pageRequest = ClusterPageRequest.builder().type("AGENT_ZK").clusterTagList(clusterTagList).build();
                List agentZkCluster = this.clusterMapper.selectByCondition(pageRequest);
                if (CollectionUtils.isNotEmpty((Collection)agentZkCluster)) {
                    agentConfigInfo.setZkUrl(((InlongClusterEntity)agentZkCluster.get(0)).getUrl());
                }
            }
            String jsonStr = GSON.toJson((Object)agentConfigInfo);
            String configMd5 = DigestUtils.md5Hex((String)jsonStr);
            agentConfigInfo.setMd5(configMd5);
            agentConfigInfo.setCode(AgentResponseCode.SUCCESS);
            agentTaskConfigEntity.setConfigParams(this.objectMapper.writeValueAsString((Object)agentConfigInfo));
            List normalSourceEntities = this.sourceMapper.selectByStatusAndCluster(SourceStatus.NORMAL_STATUS_SET.stream().map(SourceStatus::getCode).collect(Collectors.toList()), clusterName, ip, uuid);
            ArrayList taskLists = new ArrayList(normalSourceEntities);
            List stopSourceEntities = this.sourceMapper.selectByStatusAndCluster(SourceStatus.STOP_STATUS_SET.stream().map(SourceStatus::getCode).collect(Collectors.toList()), clusterName, ip, uuid);
            taskLists.addAll(stopSourceEntities);
            LOGGER.debug("success to add task : {}", (Object)taskLists.size());
            ArrayList runningTaskConfig = Lists.newArrayList();
            List cmdConfigs = this.sourceCmdConfigMapper.queryCmdByAgentIp(request.getAgentIp()).stream().map(cmd -> {
                CmdConfig cmdConfig = new CmdConfig();
                cmdConfig.setDataTime(cmd.getSpecifiedDataTime());
                cmdConfig.setOp(cmd.getCmdType());
                cmdConfig.setId(cmd.getId());
                cmdConfig.setTaskId(cmd.getTaskId());
                return cmdConfig;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(taskLists)) {
                agentTaskConfigEntity.setTaskParams("");
                this.agentTaskConfigEntityMapper.updateByIdSelective(agentTaskConfigEntity);
                return;
            }
            for (StreamSourceEntity sourceEntity : taskLists) {
                int op = sourceEntity.getStatus() % 100;
                DataConfig dataConfig = this.getDataConfig(sourceEntity, op);
                runningTaskConfig.add(dataConfig);
            }
            TaskResult taskResult = TaskResult.builder().dataConfigs((List)runningTaskConfig).cmdConfigs(cmdConfigs).build();
            String md5 = DigestUtils.md5Hex((String)GSON.toJson((Object)taskResult));
            taskResult.setMd5(md5);
            taskResult.setCode(AgentResponseCode.SUCCESS);
            agentTaskConfigEntity.setAgentIp(request.getAgentIp());
            agentTaskConfigEntity.setClusterName(request.getInlongClusterName());
            agentTaskConfigEntity.setTaskParams(this.objectMapper.writeValueAsString((Object)taskResult));
            agentClusterInfo.setModifier(operator);
            if (existEntity == null) {
                agentTaskConfigEntity.setCreator(operator);
                this.agentTaskConfigEntityMapper.insert(agentTaskConfigEntity);
            } else {
                this.agentTaskConfigEntityMapper.updateByIdSelective(agentTaskConfigEntity);
            }
            LOGGER.debug("success to update agent config info for: {}, result: {}", (Object)request, (Object)agentConfigInfo);
        }
        catch (Exception e) {
            String errMsg = String.format("update agent task config failed for groupId=%s, streamId=%s, ip=%s", request.getInlongGroupId(), request.getInlongStreamId(), request.getAgentIp());
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }

    private DataConfig getDataConfig(StreamSourceEntity entity, int op) {
        DataConfig dataConfig = new DataConfig();
        dataConfig.setIp(entity.getAgentIp());
        dataConfig.setUuid(entity.getUuid());
        dataConfig.setOp(String.valueOf(op));
        dataConfig.setTaskId(entity.getId());
        dataConfig.setTaskType(Integer.valueOf(this.getTaskType(entity)));
        dataConfig.setTaskName(entity.getSourceName());
        dataConfig.setSnapshot(entity.getSnapshot());
        dataConfig.setTimeZone(entity.getDataTimeZone());
        dataConfig.setVersion(entity.getVersion());
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        dataConfig.setInlongGroupId(groupId);
        dataConfig.setInlongStreamId(streamId);
        InlongGroupEntity groupEntity = this.groupMapper.selectByGroupIdWithoutTenant(groupId);
        InlongStreamEntity streamEntity = this.streamMapper.selectByIdentifier(groupId, streamId);
        if (this.operatorFactory == null) {
            this.operatorFactory = new SourceOperatorFactory();
            this.autowireCapableBeanFactory.autowireBean((Object)this.operatorFactory);
        }
        StreamSourceOperator sourceOperator = this.operatorFactory.getInstance(entity.getSourceType());
        String extParams = sourceOperator.getExtParams(entity);
        if (groupEntity != null && streamEntity != null) {
            dataConfig.setState(Integer.valueOf(SourceStatus.NORMAL_STATUS_SET.contains(SourceStatus.forCode((int)entity.getStatus())) ? TaskStateEnum.RUNNING.getType() : TaskStateEnum.FROZEN.getType()));
            dataConfig.setSyncSend(streamEntity.getSyncSend());
            extParams = sourceOperator.updateDataConfig(extParams, streamEntity, dataConfig);
            InlongStreamInfo streamInfo = (InlongStreamInfo)CommonBeanUtils.copyProperties((Object)streamEntity, InlongStreamInfo::new);
            InlongStreamExtParam.unpackExtParams((String)streamEntity.getExtParams(), (Object)streamInfo);
            dataConfig.setPredefinedFields(streamInfo.getPredefinedFields());
            int dataReportType = groupEntity.getDataReportType();
            dataConfig.setDataReportType(Integer.valueOf(dataReportType));
            if (InlongConstants.REPORT_TO_MQ_RECEIVED == dataReportType) {
                DataProxyTopicInfo topicConfig;
                ArrayList<MQClusterInfo> mqSet = new ArrayList<MQClusterInfo>();
                List<String> clusterTagList = Collections.singletonList(groupEntity.getInlongClusterTag());
                ClusterPageRequest pageRequest = ClusterPageRequest.builder().type(groupEntity.getMqType()).clusterTagList(clusterTagList).build();
                List mqClusterList = this.clusterMapper.selectByCondition(pageRequest);
                for (InlongClusterEntity cluster : mqClusterList) {
                    MQClusterInfo clusterInfo = new MQClusterInfo();
                    clusterInfo.setUrl(cluster.getUrl());
                    clusterInfo.setToken(cluster.getToken());
                    clusterInfo.setMqType(cluster.getType());
                    clusterInfo.setParams((Map)JsonUtils.parseObject((String)cluster.getExtParams(), HashMap.class));
                    mqSet.add(clusterInfo);
                }
                dataConfig.setMqClusters(mqSet);
                String mqResource = groupEntity.getMqResource();
                String mqType = groupEntity.getMqType();
                if ("PULSAR".equals(mqType) || "TDMQ_PULSAR".equals(mqType)) {
                    InlongPulsarDTO pulsarDTO = InlongPulsarDTO.getFromJson((String)groupEntity.getExtParams());
                    String tenant = pulsarDTO.getPulsarTenant();
                    if (StringUtils.isBlank((CharSequence)tenant)) {
                        PulsarClusterDTO pulsarCluster = PulsarClusterDTO.getFromJson((String)((InlongClusterEntity)mqClusterList.get(0)).getExtParams());
                        tenant = pulsarCluster.getPulsarTenant();
                    }
                    String topic = String.format("persistent://%s/%s/%s", tenant, mqResource, streamEntity.getMqResource());
                    DataProxyTopicInfo topicConfig2 = new DataProxyTopicInfo();
                    topicConfig2.setInlongGroupId(groupId + "/" + streamId);
                    topicConfig2.setTopic(topic);
                    dataConfig.setTopicInfo(topicConfig2);
                } else if ("TUBEMQ".equals(mqType)) {
                    topicConfig = new DataProxyTopicInfo();
                    topicConfig.setInlongGroupId(groupId);
                    topicConfig.setTopic(mqResource);
                    dataConfig.setTopicInfo(topicConfig);
                } else if ("KAFKA".equals(mqType)) {
                    topicConfig = new DataProxyTopicInfo();
                    topicConfig.setInlongGroupId(groupId);
                    topicConfig.setTopic(groupEntity.getMqResource() + "." + streamEntity.getMqResource());
                    dataConfig.setTopicInfo(topicConfig);
                }
            } else {
                LOGGER.warn("set syncSend=[0] as the stream not exists for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
            }
        }
        dataConfig.setExtParams(extParams);
        return dataConfig;
    }

    private int getTaskType(StreamSourceEntity sourceEntity) {
        TaskTypeEnum taskType = (TaskTypeEnum)SourceType.SOURCE_TASK_MAP.get(sourceEntity.getSourceType());
        if (taskType == null) {
            throw new BusinessException("Unsupported task type for source type " + sourceEntity.getSourceType());
        }
        return taskType.getType();
    }
}

