/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.HeartbeatApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.heartbeat.ComponentHeartbeatResponse;
import org.apache.inlong.manager.pojo.heartbeat.GroupHeartbeatResponse;
import org.apache.inlong.manager.pojo.heartbeat.HeartbeatPageRequest;
import org.apache.inlong.manager.pojo.heartbeat.HeartbeatQueryRequest;
import org.apache.inlong.manager.pojo.heartbeat.StreamHeartbeatResponse;

public class HeartbeatClient {
    private final HeartbeatApi heartbeatApi;

    public HeartbeatClient(ClientConfiguration configuration) {
        this.heartbeatApi = (HeartbeatApi)ClientUtils.createRetrofit(configuration).create(HeartbeatApi.class);
    }

    public ComponentHeartbeatResponse getComponentHeartbeat(HeartbeatQueryRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        Preconditions.expectNotBlank((String)request.getInstance(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_INSTANCE_EMPTY);
        Response<ComponentHeartbeatResponse> response = ClientUtils.executeHttpCall(this.heartbeatApi.getComponentHeartbeat(request));
        ClientUtils.assertRespSuccess(response);
        return (ComponentHeartbeatResponse)response.getData();
    }

    public GroupHeartbeatResponse getGroupHeartbeat(HeartbeatQueryRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        Preconditions.expectNotBlank((String)request.getInstance(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_INSTANCE_EMPTY);
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Response<GroupHeartbeatResponse> response = ClientUtils.executeHttpCall(this.heartbeatApi.getGroupHeartbeat(request));
        ClientUtils.assertRespSuccess(response);
        return (GroupHeartbeatResponse)response.getData();
    }

    public StreamHeartbeatResponse getStreamHeartbeat(HeartbeatQueryRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        Preconditions.expectNotBlank((String)request.getInstance(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_INSTANCE_EMPTY);
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)request.getInlongStreamId(), (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        Response<StreamHeartbeatResponse> response = ClientUtils.executeHttpCall(this.heartbeatApi.getStreamHeartbeat(request));
        ClientUtils.assertRespSuccess(response);
        return (StreamHeartbeatResponse)response.getData();
    }

    public PageResult<ComponentHeartbeatResponse> listComponentHeartbeat(HeartbeatPageRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        Response<PageResult<ComponentHeartbeatResponse>> response = ClientUtils.executeHttpCall(this.heartbeatApi.listComponentHeartbeat(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public PageResult<GroupHeartbeatResponse> listGroupHeartbeat(HeartbeatPageRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        Response<PageResult<GroupHeartbeatResponse>> response = ClientUtils.executeHttpCall(this.heartbeatApi.listGroupHeartbeat(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public PageResult<StreamHeartbeatResponse> listStreamHeartbeat(HeartbeatPageRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.REQUEST_COMPONENT_EMPTY);
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Response<PageResult<StreamHeartbeatResponse>> response = ClientUtils.executeHttpCall(this.heartbeatApi.listStreamHeartbeat(request));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }
}

