/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config;

import com.google.gson.Gson;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.common.enums.InlongCompressType;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.common.heartbeat.AddressInfo;
import org.apache.inlong.common.pojo.dataproxy.CacheClusterObject;
import org.apache.inlong.common.pojo.dataproxy.CacheClusterSetObject;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfigRequest;
import org.apache.inlong.common.pojo.dataproxy.DataProxyConfigResponse;
import org.apache.inlong.common.pojo.dataproxy.InLongIdObject;
import org.apache.inlong.common.pojo.dataproxy.ProxyClusterObject;
import org.apache.inlong.dataproxy.config.CommonConfigHolder;
import org.apache.inlong.dataproxy.config.ConfigHolder;
import org.apache.inlong.dataproxy.config.holder.BlackListConfigHolder;
import org.apache.inlong.dataproxy.config.holder.ConfigUpdateCallback;
import org.apache.inlong.dataproxy.config.holder.GroupIdNumConfigHolder;
import org.apache.inlong.dataproxy.config.holder.MetaConfigHolder;
import org.apache.inlong.dataproxy.config.holder.SourceReportConfigHolder;
import org.apache.inlong.dataproxy.config.holder.WeightConfigHolder;
import org.apache.inlong.dataproxy.config.holder.WhiteListConfigHolder;
import org.apache.inlong.dataproxy.config.pojo.CacheClusterConfig;
import org.apache.inlong.dataproxy.config.pojo.CacheType;
import org.apache.inlong.dataproxy.config.pojo.IdTopicConfig;
import org.apache.inlong.dataproxy.config.pojo.InLongMetaConfig;
import org.apache.inlong.dataproxy.utils.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigManager.class);
    public static final Map<ConfigHolder, Long> CONFIG_HOLDER_MAP = new ConcurrentHashMap<ConfigHolder, Long>();
    public static final AtomicBoolean handshakeManagerOk = new AtomicBoolean(false);
    private static volatile boolean isInit = false;
    private static ConfigManager instance = null;
    private final WeightConfigHolder weightConfigHolder = new WeightConfigHolder();
    private final BlackListConfigHolder blacklistConfigHolder = new BlackListConfigHolder();
    private final WhiteListConfigHolder whitelistConfigHolder = new WhiteListConfigHolder();
    private final GroupIdNumConfigHolder groupIdConfig = new GroupIdNumConfigHolder();
    private final MetaConfigHolder metaConfigHolder = new MetaConfigHolder();
    private final SourceReportConfigHolder sourceReportConfigHolder = new SourceReportConfigHolder();
    private volatile boolean mqClusterReady = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigManager getInstance() {
        if (isInit && instance != null) {
            return instance;
        }
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (!isInit) {
                instance = new ConfigManager();
                for (ConfigHolder holder : CONFIG_HOLDER_MAP.keySet()) {
                    holder.loadFromFileToHolder();
                }
                ReloadConfigWorker reloadProperties = ReloadConfigWorker.create(instance);
                reloadProperties.setDaemon(true);
                reloadProperties.start();
                isInit = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public double getCpuWeight() {
        return this.weightConfigHolder.getCachedCpuWeight();
    }

    public double getNetInWeight() {
        return this.weightConfigHolder.getCachedNetInWeight();
    }

    public double getNetOutWeight() {
        return this.weightConfigHolder.getCachedNetOutWeight();
    }

    public double getTcpWeight() {
        return this.weightConfigHolder.getCachedTcpWeight();
    }

    public double getCpuThresholdWeight() {
        return this.weightConfigHolder.getCachedCpuThreshold();
    }

    public String getTopicName(String groupId, String streamId) {
        return this.metaConfigHolder.getSrcBaseTopicName(groupId, streamId);
    }

    public IdTopicConfig getSinkIdTopicConfig(String groupId, String streamId) {
        return this.metaConfigHolder.getSinkIdTopicConfig(groupId, streamId);
    }

    public String getMetaConfigMD5() {
        return this.metaConfigHolder.getConfigMd5();
    }

    public boolean updateMetaConfigInfo(InLongMetaConfig metaConfig) {
        return this.metaConfigHolder.updateConfigMap(metaConfig);
    }

    public void regMetaConfigChgCallback(ConfigUpdateCallback callback) {
        this.metaConfigHolder.addUpdateCallback(callback);
    }

    public List<CacheClusterConfig> getCachedCLusterConfig() {
        return this.metaConfigHolder.forkCachedCLusterConfig();
    }

    public Set<String> getAllTopicNames() {
        return this.metaConfigHolder.getAllTopicName();
    }

    public boolean isEnableNum2NameTrans(String groupIdNum) {
        return this.groupIdConfig.isEnableNum2NameTrans(groupIdNum);
    }

    public boolean isGroupIdNumConfigEmpty() {
        return this.groupIdConfig.isGroupIdNumConfigEmpty();
    }

    public boolean isStreamIdNumConfigEmpty() {
        return this.groupIdConfig.isStreamIdNumConfigEmpty();
    }

    public String getGroupIdNameByNum(String groupIdNum) {
        return this.groupIdConfig.getGroupIdNameByNum(groupIdNum);
    }

    public String getStreamIdNameByIdNum(String groupIdNum, String streamIdNum) {
        return this.groupIdConfig.getStreamIdNameByIdNum(groupIdNum, streamIdNum);
    }

    public ConcurrentHashMap<String, String> getGroupIdNumMap() {
        return this.groupIdConfig.getGroupIdNumMap();
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, String>> getStreamIdNumMap() {
        return this.groupIdConfig.getStreamIdNumMap();
    }

    public void regIPVisitConfigChgCallback(ConfigUpdateCallback callback) {
        this.blacklistConfigHolder.addUpdateCallback(callback);
        this.whitelistConfigHolder.addUpdateCallback(callback);
    }

    public boolean needChkIllegalIP() {
        return this.blacklistConfigHolder.needCheckBlacklist() || this.whitelistConfigHolder.needCheckWhitelist();
    }

    public boolean isIllegalIP(String strRemoteIP) {
        return strRemoteIP == null || this.blacklistConfigHolder.isIllegalIP(strRemoteIP) || this.whitelistConfigHolder.isIllegalIP(strRemoteIP);
    }

    public void addSourceReportInfo(String sourceIp, String sourcePort, String rptSrcType, String protocolType) {
        this.sourceReportConfigHolder.addSourceInfo(sourceIp, sourcePort, rptSrcType, protocolType);
    }

    public Map<String, AddressInfo> getSrcAddressInfos() {
        return this.sourceReportConfigHolder.getSrcAddressInfos();
    }

    public boolean isMqClusterReady() {
        return this.mqClusterReady;
    }

    public void setMqClusterReady() {
        this.mqClusterReady = true;
    }

    public static class ReloadConfigWorker
    extends Thread {
        private final ConfigManager configManager;
        private final CloseableHttpClient httpClient;
        private final Gson gson = new Gson();
        private boolean isRunning = true;
        private final AtomicInteger managerIpListIndex = new AtomicInteger(0);

        private ReloadConfigWorker(ConfigManager managerInstance) {
            this.configManager = managerInstance;
            this.httpClient = this.constructHttpClient();
            SecureRandom random = new SecureRandom(String.valueOf(System.currentTimeMillis()).getBytes());
            this.managerIpListIndex.set(random.nextInt());
        }

        public static ReloadConfigWorker create(ConfigManager managerInstance) {
            return new ReloadConfigWorker(managerInstance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long count = 0L;
            LOG.info("Reload-Config Worker started!");
            while (this.isRunning) {
                long startTime = System.currentTimeMillis();
                try {
                    long wstTime;
                    for (ConfigHolder holder : CONFIG_HOLDER_MAP.keySet()) {
                        if (!holder.checkAndUpdateHolder()) continue;
                        holder.executeCallbacks();
                    }
                    if (count % 3L == 0L) {
                        this.checkRemoteConfig();
                    }
                    if ((wstTime = System.currentTimeMillis() - startTime) > 60000L) {
                        LOG.warn("Reload-Config Worker process wast({}) over 60000 millis", (Object)wstTime);
                    }
                    TimeUnit.MILLISECONDS.sleep(CommonConfigHolder.getInstance().getMetaConfigSyncInvlMs() + (long)this.getRandom(0, 5000));
                }
                catch (InterruptedException ex1) {
                    LOG.error("Reload-Config Worker encounters an interrupt exception, break processing", (Throwable)ex1);
                    break;
                }
                catch (Throwable ex2) {
                    LOG.error("Reload-Config Worker encounters exception, continue process", ex2);
                }
                finally {
                    ++count;
                }
            }
            LOG.info("Reload-Config Worker existed!");
        }

        public void close() {
            this.isRunning = false;
        }

        private synchronized CloseableHttpClient constructHttpClient() {
            long timeoutInMs = TimeUnit.MILLISECONDS.toMillis(50000L);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)timeoutInMs).setSocketTimeout((int)timeoutInMs).build();
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            return httpClientBuilder.build();
        }

        private int getRandom(int min, int max) {
            return (int)(Math.random() * (double)(max + 1 - min)) + min;
        }

        private void checkRemoteConfig() {
            List<String> managerIpList = CommonConfigHolder.getInstance().getManagerHosts();
            int managerIpSize = managerIpList.size();
            for (int i = 0; i < managerIpList.size(); ++i) {
                String host = managerIpList.get(Math.abs(this.managerIpListIndex.getAndIncrement()) % managerIpSize);
                if (this.reloadDataProxyConfig(CommonConfigHolder.getInstance().getClusterName(), CommonConfigHolder.getInstance().getClusterTag(), host)) break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean reloadDataProxyConfig(String clusterName, String clusterTag, String host) {
            String url = null;
            HttpPost httpPost = null;
            try {
                DataProxyConfigResponse proxyResponse;
                url = "http://" + host + "/inlong/manager/openapi" + "/dataproxy/getAllConfig";
                httpPost = HttpUtils.getHttPost(url);
                DataProxyConfigRequest request = new DataProxyConfigRequest();
                request.setClusterName(clusterName);
                request.setClusterTag(clusterTag);
                if (StringUtils.isNotBlank((CharSequence)this.configManager.getMetaConfigMD5())) {
                    request.setMd5(this.configManager.getMetaConfigMD5());
                }
                httpPost.setEntity((HttpEntity)HttpUtils.getEntity(request));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sync meta: start to get config, to:{}, params: {}, headers: {}", new Object[]{url, request, httpPost.getAllHeaders()});
                }
                long startTime = System.currentTimeMillis();
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
                String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
                long dltTime = System.currentTimeMillis() - startTime;
                if (dltTime >= CommonConfigHolder.getInstance().getMetaConfigWastAlarmMs()) {
                    LOG.warn("Sync meta: end to get config, WAIST {} ms, over alarm: {} ms, from:{}", new Object[]{dltTime, CommonConfigHolder.getInstance().getMetaConfigWastAlarmMs(), url});
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Sync meta: end to get config, WAIST {} ms, from:{}, result:{}", new Object[]{dltTime, url, returnStr});
                }
                if (response.getStatusLine().getStatusCode() != 200) {
                    LOG.error("Sync meta: return failure, errCode {}, from:{}, params:{}, headers:{}, response:{}", new Object[]{response.getStatusLine().getStatusCode(), url, request, httpPost.getAllHeaders(), returnStr});
                    boolean bl = false;
                    return bl;
                }
                try {
                    proxyResponse = (DataProxyConfigResponse)this.gson.fromJson(returnStr, DataProxyConfigResponse.class);
                }
                catch (Throwable e) {
                    LOG.error("Sync meta: exception thrown while parsing config, from:{}, params:{}, response:{}", new Object[]{url, request, returnStr, e});
                    boolean bl = false;
                    if (httpPost != null) {
                        httpPost.releaseConnection();
                    }
                    return bl;
                }
                ImmutablePair<Boolean, String> validResult = this.validRequiredFields(proxyResponse);
                if (!((Boolean)validResult.getLeft()).booleanValue()) {
                    if (proxyResponse.getErrCode() != 1) {
                        LOG.error("Sync meta: {}, from:{}, params:{}, return:{}", new Object[]{validResult.getRight(), url, request, returnStr});
                    }
                    boolean bl = true;
                    return bl;
                }
                ImmutablePair<CacheType, Map<String, CacheClusterConfig>> clusterInfo = this.buildCacheClusterConfig(proxyResponse.getData().getCacheClusterSet());
                if (clusterInfo.getLeft() == CacheType.N) {
                    LOG.error("Sync meta: unsupported mq type {}, from:{}, params:{}, return:{}", new Object[]{clusterInfo.getLeft(), url, request, returnStr});
                    boolean bl = true;
                    return bl;
                }
                if (((Map)clusterInfo.getRight()).isEmpty()) {
                    LOG.error("Sync meta: cacheClusters is empty, from:{}, params:{}, return:{}", new Object[]{url, request, returnStr});
                    boolean bl = true;
                    return bl;
                }
                Map<String, IdTopicConfig> idTopicConfigMap = this.buildCacheTopicConfig((CacheType)((Object)clusterInfo.getLeft()), proxyResponse.getData().getProxyCluster());
                InLongMetaConfig inLongMetaConfig = new InLongMetaConfig(proxyResponse.getMd5(), (CacheType)((Object)clusterInfo.getLeft()), (Map)clusterInfo.getRight(), idTopicConfigMap);
                this.configManager.updateMetaConfigInfo(inLongMetaConfig);
                if (handshakeManagerOk.get()) {
                    LOG.info("Sync meta: sync config success, from:{}", (Object)url);
                } else {
                    handshakeManagerOk.set(true);
                    LOG.info("Sync meta: sync config success, handshake manager ok, from:{}", (Object)url);
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable ex) {
                LOG.error("Sync meta: process throw exception, from:{}", url, (Object)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
            }
        }

        public ImmutablePair<Boolean, String> validRequiredFields(DataProxyConfigResponse response) {
            if (response == null) {
                return ImmutablePair.of((Object)false, (Object)"parse result is null");
            }
            if (!response.isResult().booleanValue()) {
                return ImmutablePair.of((Object)false, (Object)"result is NOT true");
            }
            if (response.getErrCode() != 0) {
                return ImmutablePair.of((Object)false, (Object)("errCode is " + response.getErrCode() + ", NOT success"));
            }
            if (response.getMd5() == null) {
                return ImmutablePair.of((Object)false, (Object)"md5 field is null");
            }
            if (response.getData() == null) {
                return ImmutablePair.of((Object)false, (Object)"data field is null");
            }
            if (response.getData().getProxyCluster() == null) {
                return ImmutablePair.of((Object)false, (Object)"proxyCluster field is null");
            }
            if (response.getData().getCacheClusterSet() == null) {
                return ImmutablePair.of((Object)false, (Object)"cacheClusterSet field is null");
            }
            if (response.getData().getProxyCluster().getInlongIds() == null) {
                return ImmutablePair.of((Object)false, (Object)"inlongIds field is null");
            }
            if (response.getData().getCacheClusterSet().getCacheClusters() == null) {
                return ImmutablePair.of((Object)false, (Object)"cacheClusters field is null");
            }
            return ImmutablePair.of((Object)true, (Object)"ok");
        }

        private ImmutablePair<CacheType, Map<String, CacheClusterConfig>> buildCacheClusterConfig(CacheClusterSetObject clusterSetObject) {
            CacheType mqType = CacheType.convert(clusterSetObject.getType());
            HashMap<String, CacheClusterConfig> result = new HashMap<String, CacheClusterConfig>();
            for (CacheClusterObject clusterObject : clusterSetObject.getCacheClusters()) {
                if (clusterObject == null || StringUtils.isBlank((CharSequence)clusterObject.getName())) continue;
                CacheClusterConfig config = new CacheClusterConfig();
                config.setClusterName(clusterObject.getName());
                config.setToken(clusterObject.getToken());
                config.getParams().putAll(clusterObject.getParams());
                result.put(config.getClusterName(), config);
            }
            return ImmutablePair.of((Object)((Object)mqType), result);
        }

        private Map<String, IdTopicConfig> buildCacheTopicConfig(CacheType mqType, ProxyClusterObject proxyClusterObject) {
            HashMap<String, IdTopicConfig> tmpTopicConfigMap = new HashMap<String, IdTopicConfig>();
            List inLongIds = proxyClusterObject.getInlongIds();
            if (inLongIds.isEmpty()) {
                return tmpTopicConfigMap;
            }
            for (InLongIdObject idObject : inLongIds) {
                String streamId;
                String groupId;
                if (idObject == null || StringUtils.isBlank((CharSequence)idObject.getInlongId()) || StringUtils.isBlank((CharSequence)idObject.getTopic())) continue;
                String[] idItems = idObject.getInlongId().split("\\.");
                if (idItems.length == 2) {
                    if (StringUtils.isBlank((CharSequence)idItems[0])) continue;
                    groupId = idItems[0].trim();
                    streamId = idItems[1].trim();
                } else {
                    groupId = idObject.getInlongId().trim();
                    streamId = "";
                }
                String topicName = idObject.getTopic().trim();
                int index = topicName.lastIndexOf(47);
                if (index >= 0) {
                    topicName = topicName.substring(index + 1).trim();
                }
                String tenant = idObject.getParams().getOrDefault("tenant", "");
                String nameSpace = idObject.getParams().getOrDefault("namespace", "");
                if (StringUtils.isBlank((CharSequence)idObject.getTopic())) continue;
                if (mqType.equals((Object)CacheType.TUBE)) {
                    topicName = nameSpace;
                } else if (mqType.equals((Object)CacheType.KAFKA) && topicName.equals(streamId)) {
                    topicName = String.format("%s.%s", nameSpace, topicName);
                }
                IdTopicConfig tmpConfig = new IdTopicConfig();
                tmpConfig.setInlongGroupIdAndStreamId(groupId, streamId);
                tmpConfig.setTenantAndNameSpace(tenant, nameSpace);
                tmpConfig.setTopicName(topicName);
                tmpConfig.setParams(idObject.getParams());
                tmpConfig.setDataType(DataTypeEnum.convert((String)idObject.getParams().getOrDefault("dataType", DataTypeEnum.TEXT.getType())));
                tmpConfig.setFieldDelimiter(idObject.getParams().getOrDefault("fieldDelimiter", "|"));
                tmpConfig.setFileDelimiter(idObject.getParams().getOrDefault("fileDelimiter", "\n"));
                tmpConfig.setUseExtendedFields(Boolean.valueOf(idObject.getParams().getOrDefault("useExtendedFields", "false")));
                tmpConfig.setMsgWrapType(this.getPbWrapType(idObject));
                tmpConfig.setV1CompressType(this.getPbCompressType(idObject));
                tmpTopicConfigMap.put(tmpConfig.getUid(), tmpConfig);
                if (!mqType.equals((Object)CacheType.TUBE) || tmpConfig.getUid().equals(tmpConfig.getInlongGroupId()) || tmpTopicConfigMap.get(tmpConfig.getInlongGroupId()) != null) continue;
                IdTopicConfig tmpConfig2 = new IdTopicConfig();
                tmpConfig2.setInlongGroupIdAndStreamId(groupId, "");
                tmpConfig2.setTenantAndNameSpace(tenant, nameSpace);
                tmpConfig2.setTopicName(topicName);
                tmpConfig2.setDataType(tmpConfig.getDataType());
                tmpConfig2.setFieldDelimiter(tmpConfig.getFieldDelimiter());
                tmpConfig2.setFileDelimiter(tmpConfig.getFileDelimiter());
                tmpConfig2.setParams(new HashMap<String, String>(tmpConfig.getParams()));
                tmpConfig2.setUseExtendedFields(tmpConfig.isUseExtendedFields());
                tmpConfig2.setMsgWrapType(tmpConfig.getMsgWrapType());
                tmpConfig2.setV1CompressType(tmpConfig.getV1CompressType());
                tmpTopicConfigMap.put(tmpConfig2.getUid(), tmpConfig2);
            }
            return tmpTopicConfigMap;
        }

        private MessageWrapType getPbWrapType(InLongIdObject idObject) {
            String strWrapType = (String)idObject.getParams().get("wrapType");
            if (StringUtils.isBlank((CharSequence)strWrapType)) {
                return MessageWrapType.UNKNOWN;
            }
            return MessageWrapType.forType((String)strWrapType);
        }

        private InlongCompressType getPbCompressType(InLongIdObject idObject) {
            String strCompressType = (String)idObject.getParams().get("inlongCompressType");
            if (StringUtils.isBlank((CharSequence)strCompressType)) {
                return CommonConfigHolder.getInstance().getDefV1MsgCompressType();
            }
            InlongCompressType msgCompType = InlongCompressType.forType((String)strCompressType);
            if (msgCompType == InlongCompressType.UNKNOWN) {
                return CommonConfigHolder.getInstance().getDefV1MsgCompressType();
            }
            return msgCompType;
        }
    }
}

