/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyAccessorFactory;

public class CommonBeanUtils
extends BeanUtils {
    public static <S, T> List<T> copyListProperties(List<S> sources, Supplier<T> target) {
        if (sources == null || sources.isEmpty()) {
            return new ArrayList(0);
        }
        ArrayList<T> list = new ArrayList<T>(sources.size());
        for (S source : sources) {
            T t = target.get();
            CommonBeanUtils.copyProperties(source, t);
            list.add(t);
        }
        return list;
    }

    public static <S, T> T copyProperties(S source, Supplier<T> target) {
        T result = target.get();
        if (source == null) {
            return result;
        }
        CommonBeanUtils.copyProperties(source, result);
        return result;
    }

    public static <S, T> T copyProperties(S source, T target, boolean ignoreNull) {
        if (source == null) {
            return target;
        }
        if (ignoreNull) {
            CommonBeanUtils.copyProperties(source, target, (String[])CommonBeanUtils.getNullPropertyNames(source));
        } else {
            CommonBeanUtils.copyProperties(source, target);
        }
        return target;
    }

    public static <S, T> T copyProperties(S source, Supplier<T> target, boolean ignoreNull) {
        T result = target.get();
        if (source == null) {
            return result;
        }
        if (ignoreNull) {
            CommonBeanUtils.copyProperties(source, result, (String[])CommonBeanUtils.getNullPropertyNames(source));
        } else {
            CommonBeanUtils.copyProperties(source, result);
        }
        return result;
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static <S, T> T copyPropertiesWithEnumSupport(S source, Supplier<T> target) {
        T result = target.get();
        if (source == null) {
            return result;
        }
        BeanWrapperImpl sourceWrapper = new BeanWrapperImpl(source);
        BeanWrapper targetWrapper = PropertyAccessorFactory.forBeanPropertyAccess(result);
        for (PropertyDescriptor sourcePd : sourceWrapper.getPropertyDescriptors()) {
            String propertyName = sourcePd.getName();
            try {
                PropertyDescriptor targetPd = new PropertyDescriptor(propertyName, target.get().getClass());
                Object sourceValue = sourceWrapper.getPropertyValue(propertyName);
                if (sourceValue == null) continue;
                Object targetValue = sourceValue;
                if (sourceValue instanceof Enum && targetPd.getPropertyType() == String.class) {
                    targetValue = ((Enum)sourceValue).name();
                }
                targetWrapper.setPropertyValue(propertyName, targetValue);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }
}

