/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

public class UrlVerificationUtils {
    public static void extractHostAndValidatePortFromJdbcUrl(String fullUrl, String prefix) throws Exception {
        if (!fullUrl.startsWith(prefix)) {
            throw new Exception("Invalid JDBC URL, it should start with " + prefix);
        }
        String hostPortPart = fullUrl.substring(prefix.length());
        String[] hostPortParts = hostPortPart.split("/");
        if (hostPortParts.length < 1) {
            throw new Exception("Invalid JDBC URL format");
        }
        String hostPort = hostPortParts[0];
        String[] hostPortSplit = hostPort.split(":");
        if (hostPortSplit.length != 2) {
            throw new Exception("Invalid host:port format in JDBC URL");
        }
        String portStr = hostPortSplit[1];
        try {
            int portNumber = Integer.parseInt(portStr);
            if (portNumber < 1 || portNumber > 65535) {
                throw new Exception("Invalid port number in JDBC URL");
            }
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid port number format in JDBC URL");
        }
    }
}

