/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.Content;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ExampleBuilder;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.builders.SimpleParameterSpecificationBuilder;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ScalarType;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.ParameterStyle;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;

@Order(value=-2147481648)
@Component
public class OpenApiParameterBuilder
implements ParameterBuilderPlugin {
    private final DescriptionResolver descriptions;

    @Autowired
    public OpenApiParameterBuilder(DescriptionResolver descriptions) {
        this.descriptions = descriptions;
    }

    public void apply(ParameterContext context) {
        Optional parameterAnnotation = context.resolvedMethodParameter().findAnnotation(Parameter.class);
        AllowableListValues allowedValues = new AllowableListValues((List)parameterAnnotation.map(p -> Arrays.asList(p.schema().allowableValues())).orElse(new ArrayList()), "LIST");
        context.parameterBuilder().allowableValues((AllowableValues)allowedValues);
        context.requestParameterBuilder().query(arg_0 -> OpenApiParameterBuilder.lambda$apply$2((AllowableValues)allowedValues, arg_0));
        if (parameterAnnotation.isPresent()) {
            Parameter annotation = (Parameter)parameterAnnotation.get();
            Example example = null;
            if (annotation.example().length() > 0) {
                example = new ExampleBuilder().value((Object)annotation.example()).build();
            }
            Optional scalarType = ScalarType.from((String)annotation.schema().type(), (String)annotation.schema().format());
            context.requestParameterBuilder().name(annotation.name()).description(this.descriptions.resolve(annotation.description())).required(Boolean.valueOf(annotation.required())).hidden(Boolean.valueOf(annotation.hidden())).precedence(-2147481648).query(q -> q.model(m -> scalarType.ifPresent(arg_0 -> ((ModelSpecificationBuilder)m).maybeConvertToScalar(arg_0))).defaultValue(annotation.schema().defaultValue()).allowEmptyValue(Boolean.valueOf(annotation.allowEmptyValue())).explode(this.translateExplodeOption(annotation.explode())).style(this.translateStyle(annotation.style()))).example(example).examples(Examples.allExamples("", annotation.examples())).examples(this.contentExamples(annotation.content()));
        }
    }

    private ParameterStyle translateStyle(io.swagger.v3.oas.annotations.enums.ParameterStyle style) {
        return ParameterStyle.valueOf((String)style.name());
    }

    private Boolean translateExplodeOption(Explode explode) {
        if (explode == Explode.DEFAULT) {
            return null;
        }
        return explode == Explode.TRUE;
    }

    private Collection<Example> contentExamples(Content[] contents) {
        return Arrays.stream(contents).flatMap(c -> Examples.allExamples(c.mediaType(), c.examples()).stream()).collect(Collectors.toList());
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private static /* synthetic */ void lambda$apply$2(AllowableValues allowedValues, SimpleParameterSpecificationBuilder q) {
        q.enumerationFacet(e -> e.allowedValues(allowedValues));
    }
}

