/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.recover;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.StandardOpenOption;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALFileVersion;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALMetaData;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALWriter;

public class WALRepairWriter {
    private final File logFile;

    public WALRepairWriter(File logFile) {
        this.logFile = logFile;
    }

    public void repair(WALMetaData metaData) throws IOException {
        WALFileVersion version = WALFileVersion.getVersion(this.logFile);
        if (version.getVersionString().equals(this.readTailMagic(version))) {
            return;
        }
        long truncateSize = metaData.getTruncateOffSet();
        try (FileChannel channel = FileChannel.open(this.logFile.toPath(), StandardOpenOption.APPEND);){
            channel.truncate(truncateSize);
        }
        try (WALWriter walWriter = new WALWriter(this.logFile, version);){
            walWriter.updateMetaData(metaData);
        }
    }

    private String readTailMagic(WALFileVersion version) throws IOException {
        int size = version.getVersionBytes().length;
        if (this.logFile.length() < (long)size) {
            return null;
        }
        try (FileChannel channel = FileChannel.open(this.logFile.toPath(), StandardOpenOption.READ);){
            ByteBuffer magicStringBytes = ByteBuffer.allocate(size);
            channel.read(magicStringBytes, channel.size() - (long)size);
            magicStringBytes.flip();
            String string = new String(magicStringBytes.array(), StandardCharsets.UTF_8);
            return string;
        }
    }
}

