/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.AbstractTemporalCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.PostgresqlTimeFormatter;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import reactor.util.annotation.Nullable;

final class LocalTimeCodec
extends AbstractTemporalCodec<LocalTime> {
    LocalTimeCodec(ByteBufAllocator byteBufAllocator) {
        super(LocalTime.class, byteBufAllocator, PostgresqlObjectId.TIME, PostgresqlObjectId.TIME_ARRAY, PostgresqlTimeFormatter::toString);
    }

    @Override
    LocalTime doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, Class<? extends LocalTime> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        return this.decodeTemporal(buffer, dataType, format, LocalTime.class, temporal -> {
            if (temporal instanceof LocalDateTime) {
                return ((LocalDateTime)temporal).toLocalTime();
            }
            return Instant.from(temporal).atOffset(ZoneOffset.UTC).toLocalTime();
        });
    }
}

