/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculation;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksum;
import software.amazon.awssdk.crt.s3.ChecksumAlgorithm;
import software.amazon.awssdk.crt.s3.ChecksumConfig;
import software.amazon.awssdk.crt.s3.S3MetaRequestOptions;

@SdkInternalApi
public final class CrtChecksumUtils {
    private static final ChecksumAlgorithm DEFAULT_CHECKSUM_ALGO = ChecksumAlgorithm.CRC32;

    private CrtChecksumUtils() {
    }

    public static ChecksumConfig checksumConfig(HttpChecksum httpChecksum, S3MetaRequestOptions.MetaRequestType requestType, RequestChecksumCalculation requestChecksumCalculation, ResponseChecksumValidation responseChecksumValidation) {
        if (httpChecksum == null) {
            return new ChecksumConfig();
        }
        ChecksumAlgorithm checksumAlgorithm = CrtChecksumUtils.crtChecksumAlgorithm(httpChecksum, requestChecksumCalculation);
        boolean validateChecksum = CrtChecksumUtils.validateResponseChecksum(httpChecksum, requestType, responseChecksumValidation);
        ChecksumConfig.ChecksumLocation checksumLocation = checksumAlgorithm == ChecksumAlgorithm.NONE ? ChecksumConfig.ChecksumLocation.NONE : (httpChecksum.isRequestStreaming() ? ChecksumConfig.ChecksumLocation.TRAILER : ChecksumConfig.ChecksumLocation.HEADER);
        return new ChecksumConfig().withChecksumAlgorithm(checksumAlgorithm).withValidateChecksum(validateChecksum).withChecksumLocation(checksumLocation).withValidateChecksumAlgorithmList(CrtChecksumUtils.checksumAlgorithmList(httpChecksum));
    }

    private static List<ChecksumAlgorithm> checksumAlgorithmList(HttpChecksum httpChecksum) {
        if (httpChecksum.responseAlgorithms() == null) {
            return null;
        }
        return httpChecksum.responseAlgorithms().stream().map(CrtChecksumUtils::toCrtChecksumAlgorithm).collect(Collectors.toList());
    }

    private static ChecksumAlgorithm crtChecksumAlgorithm(HttpChecksum httpChecksum, RequestChecksumCalculation requestChecksumCalculation) {
        if (httpChecksum.requestAlgorithm() == null) {
            if (!httpChecksum.isRequestChecksumRequired() && requestChecksumCalculation == RequestChecksumCalculation.WHEN_REQUIRED) {
                return ChecksumAlgorithm.NONE;
            }
            return DEFAULT_CHECKSUM_ALGO;
        }
        return CrtChecksumUtils.toCrtChecksumAlgorithm(httpChecksum.requestAlgorithm());
    }

    private static ChecksumAlgorithm toCrtChecksumAlgorithm(String sdkChecksum) {
        return ChecksumAlgorithm.valueOf((String)sdkChecksum.toUpperCase());
    }

    private static boolean validateResponseChecksum(HttpChecksum httpChecksum, S3MetaRequestOptions.MetaRequestType requestType, ResponseChecksumValidation responseChecksumValidation) {
        if (requestType != S3MetaRequestOptions.MetaRequestType.GET_OBJECT) {
            return false;
        }
        return responseChecksumValidation == ResponseChecksumValidation.WHEN_SUPPORTED || httpChecksum.requestValidationMode() != null;
    }
}

