/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.netty.handler.codec.compression;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.handler.codec.compression.CompressionUtil;
import org.apache.pulsar.shade.io.netty.util.ByteProcessor;
import org.apache.pulsar.shade.io.netty.util.internal.ObjectUtil;
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;

abstract class ByteBufChecksum
implements Checksum {
    private final ByteProcessor updateProcessor = new ByteProcessor(){

        @Override
        public boolean process(byte value) throws Exception {
            ByteBufChecksum.this.update(value);
            return true;
        }
    };

    ByteBufChecksum() {
    }

    private static Method updateByteBuffer(Checksum checksum) {
        if (PlatformDependent.javaVersion() >= 8) {
            try {
                Method method = checksum.getClass().getDeclaredMethod("update", ByteBuffer.class);
                method.invoke((Object)checksum, ByteBuffer.allocate(1));
                return method;
            }
            catch (Throwable ignore) {
                return null;
            }
        }
        return null;
    }

    static ByteBufChecksum wrapChecksum(Checksum checksum) {
        ObjectUtil.checkNotNull(checksum, "checksum");
        if (checksum instanceof ByteBufChecksum) {
            return (ByteBufChecksum)checksum;
        }
        if (checksum instanceof Adler32 && ZlibChecksumMethods.ADLER32_UPDATE_METHOD != null) {
            return new ReflectiveByteBufChecksum(checksum, ZlibChecksumMethods.ADLER32_UPDATE_METHOD);
        }
        if (checksum instanceof CRC32 && ZlibChecksumMethods.CRC32_UPDATE_METHOD != null) {
            return new ReflectiveByteBufChecksum(checksum, ZlibChecksumMethods.CRC32_UPDATE_METHOD);
        }
        return new SlowByteBufChecksum(checksum);
    }

    public void update(ByteBuf b, int off, int len) {
        if (b.hasArray()) {
            this.update(b.array(), b.arrayOffset() + off, len);
        } else {
            b.forEachByte(off, len, this.updateProcessor);
        }
    }

    static /* synthetic */ Method access$000(Checksum x0) {
        return ByteBufChecksum.updateByteBuffer(x0);
    }

    private static class SlowByteBufChecksum
    extends ByteBufChecksum {
        protected final Checksum checksum;

        SlowByteBufChecksum(Checksum checksum) {
            this.checksum = checksum;
        }

        @Override
        public void update(int b) {
            this.checksum.update(b);
        }

        @Override
        public void update(byte[] b, int off, int len) {
            this.checksum.update(b, off, len);
        }

        @Override
        public long getValue() {
            return this.checksum.getValue();
        }

        @Override
        public void reset() {
            this.checksum.reset();
        }
    }

    private static final class ReflectiveByteBufChecksum
    extends SlowByteBufChecksum {
        private final Method method;

        ReflectiveByteBufChecksum(Checksum checksum, Method method) {
            super(checksum);
            this.method = method;
        }

        @Override
        public void update(ByteBuf b, int off, int len) {
            if (b.hasArray()) {
                this.update(b.array(), b.arrayOffset() + off, len);
            } else {
                try {
                    this.method.invoke((Object)this.checksum, CompressionUtil.safeNioBuffer(b, off, len));
                }
                catch (Throwable cause) {
                    throw new Error();
                }
            }
        }
    }

    private static class ZlibChecksumMethods {
        private static final Method ADLER32_UPDATE_METHOD = ByteBufChecksum.access$000(new Adler32());
        private static final Method CRC32_UPDATE_METHOD = ByteBufChecksum.access$000(new CRC32());

        private ZlibChecksumMethods() {
        }
    }
}

