/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.EntryRebalancingResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedEntryRebalancingRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TextFormattedEntryRebalancingResultAccessLogMessage
extends TextFormattedEntryRebalancingRequestAccessLogMessage
implements EntryRebalancingResultAccessLogMessage {
    private static final long serialVersionUID = -7982343893371640864L;
    @Nullable
    private final Boolean sourceAltered;
    @Nullable
    private final Boolean targetAltered;
    @Nullable
    private final Integer entriesAddedToTarget;
    @Nullable
    private final Integer entriesDeletedFromSource;
    @Nullable
    private final Integer entriesReadFromSource;
    @Nullable
    private final ResultCode resultCode;
    @Nullable
    private final String adminActionMessage;
    @Nullable
    private final String errorMessage = this.getString(TextFormattedAccessLogFields.ENTRY_REBALANCING_ERROR_MESSAGE);

    public TextFormattedEntryRebalancingResultAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedEntryRebalancingResultAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.adminActionMessage = this.getString(TextFormattedAccessLogFields.ENTRY_REBALANCING_ADMIN_ACTION_MESSAGE);
        this.sourceAltered = this.getBooleanNoThrow(TextFormattedAccessLogFields.ENTRY_REBALANCING_SOURCE_SERVER_ALTERED);
        this.targetAltered = this.getBooleanNoThrow(TextFormattedAccessLogFields.ENTRY_REBALANCING_TARGET_SERVER_ALTERED);
        this.entriesReadFromSource = this.getIntegerNoThrow(TextFormattedAccessLogFields.ENTRY_REBALANCING_ENTRIES_READ_FROM_SOURCE);
        this.entriesAddedToTarget = this.getIntegerNoThrow(TextFormattedAccessLogFields.ENTRY_REBALANCING_ENTRIES_ADDED_TO_TARGET);
        this.entriesDeletedFromSource = this.getIntegerNoThrow(TextFormattedAccessLogFields.ENTRY_REBALANCING_ENTRIES_DELETED_FROM_SOURCE);
        Integer resultCodeValue = this.getIntegerNoThrow(TextFormattedAccessLogFields.RESULT_CODE_VALUE);
        this.resultCode = resultCodeValue == null ? null : ResultCode.valueOf(resultCodeValue);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.ENTRY_REBALANCING_RESULT;
    }

    @Override
    @Nullable
    public ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @Nullable
    public String getAdminActionMessage() {
        return this.adminActionMessage;
    }

    @Override
    @Nullable
    public Boolean getSourceServerAltered() {
        return this.sourceAltered;
    }

    @Override
    @Nullable
    public Boolean getTargetServerAltered() {
        return this.targetAltered;
    }

    @Override
    @Nullable
    public Integer getEntriesReadFromSource() {
        return this.entriesReadFromSource;
    }

    @Override
    @Nullable
    public Integer getEntriesAddedToTarget() {
        return this.entriesAddedToTarget;
    }

    @Override
    @Nullable
    public Integer getEntriesDeletedFromSource() {
        return this.entriesDeletedFromSource;
    }
}

