/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.server;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.json.DTOConverter;
import org.apache.james.server.task.json.TaskExtensionModule;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.utils.ExtensionConfiguration;
import org.apache.james.utils.GuiceLoader;
import org.apache.james.utils.NamingScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSerializationModule
extends AbstractModule {
    public static final Logger LOGGER = LoggerFactory.getLogger(TaskSerializationModule.class);

    @Provides
    @Named(value="additional_information_dto")
    @Singleton
    public Set<AdditionalInformationDTOModule<? extends TaskExecutionDetails.AdditionalInformation, ? extends AdditionalInformationDTO>> provideAdditionalInformationDTOModules(Set<AdditionalInformationDTOModule<? extends TaskExecutionDetails.AdditionalInformation, ? extends AdditionalInformationDTO>> additionalInformationDTOModules, ExtensionConfiguration extensionConfiguration, GuiceLoader loader) {
        Set extensionAdditionalInformationDTOModules = extensionConfiguration.getTaskExtensions().stream().map(Throwing.function(arg_0 -> ((GuiceLoader.InvocationPerformer)loader.withNamingSheme(NamingScheme.IDENTITY)).instantiate(arg_0))).map(TaskExtensionModule::taskAdditionalInformationDTOModules).flatMap(Collection::stream).collect(Collectors.toSet());
        LOGGER.debug("TaskSerialization/AdditionalInformationDTOModule size = {}", (Object)extensionAdditionalInformationDTOModules.size());
        return ImmutableSet.builder().addAll(additionalInformationDTOModules).addAll(extensionAdditionalInformationDTOModules).build();
    }

    @Provides
    @Named(value="task_dto")
    @Singleton
    public Set<TaskDTOModule<? extends Task, ? extends TaskDTO>> provideTaskDTOModules(Set<TaskDTOModule<? extends Task, ? extends TaskDTO>> taskDTOModules, ExtensionConfiguration extensionConfiguration, GuiceLoader loader) {
        Set extensionTaskDTOModules = extensionConfiguration.getTaskExtensions().stream().map(Throwing.function(arg_0 -> ((GuiceLoader.InvocationPerformer)loader.withNamingSheme(NamingScheme.IDENTITY)).instantiate(arg_0))).map(TaskExtensionModule::taskDTOModules).flatMap(Collection::stream).collect(Collectors.toSet());
        LOGGER.debug("TaskSerialization/TaskDTOModule size = {}", (Object)extensionTaskDTOModules.size());
        return ImmutableSet.builder().addAll(taskDTOModules).addAll(extensionTaskDTOModules).build();
    }

    @Provides
    @Singleton
    public DTOConverter<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO> additionalInformationDTOConverter(@Named(value="additional_information_dto") Set<AdditionalInformationDTOModule<? extends TaskExecutionDetails.AdditionalInformation, ? extends AdditionalInformationDTO>> modules) {
        return new DTOConverter(modules);
    }

    @Provides
    @Singleton
    public DTOConverter<Task, TaskDTO> taskDTOConverter(@Named(value="task_dto") Set<TaskDTOModule<? extends Task, ? extends TaskDTO>> taskDTOModules) {
        return new DTOConverter(taskDTOModules);
    }
}

