/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.context.integration;

import io.micrometer.context.ThreadLocalAccessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.MDC;

public class Slf4jThreadLocalAccessor
implements ThreadLocalAccessor<Map<String, String>> {
    public static final String KEY = "cp.slf4j";
    private final ThreadLocalAccessor<Map<String, String>> delegate;

    public Slf4jThreadLocalAccessor(String ... keys) {
        this.delegate = keys.length == 0 ? new GlobalMdcThreadLocalAccessor() : new SelectiveMdcThreadLocalAccessor(Arrays.asList(keys));
    }

    @Override
    public Object key() {
        return KEY;
    }

    @Override
    public Map<String, String> getValue() {
        return this.delegate.getValue();
    }

    @Override
    public void setValue(Map<String, String> value) {
        this.delegate.setValue(value);
    }

    @Override
    public void setValue() {
        this.delegate.setValue();
    }

    private static final class GlobalMdcThreadLocalAccessor
    implements ThreadLocalAccessor<Map<String, String>> {
        private GlobalMdcThreadLocalAccessor() {
        }

        @Override
        public Object key() {
            return Slf4jThreadLocalAccessor.KEY;
        }

        @Override
        public Map<String, String> getValue() {
            return MDC.getCopyOfContextMap();
        }

        @Override
        public void setValue(Map<String, String> value) {
            MDC.setContextMap(value);
        }

        @Override
        public void setValue() {
            MDC.clear();
        }
    }

    private static final class SelectiveMdcThreadLocalAccessor
    implements ThreadLocalAccessor<Map<String, String>> {
        private final List<String> keys;

        SelectiveMdcThreadLocalAccessor(List<String> keys) {
            this.keys = keys;
        }

        @Override
        public Object key() {
            return Slf4jThreadLocalAccessor.KEY;
        }

        @Override
        public Map<String, String> getValue() {
            HashMap<String, String> values = new HashMap<String, String>(this.keys.size());
            for (String key : this.keys) {
                values.put(key, MDC.get((String)key));
            }
            return values;
        }

        @Override
        public void setValue(Map<String, String> value) {
            for (String key : this.keys) {
                String mdcValue = value.get(key);
                if (mdcValue != null) {
                    MDC.put((String)key, (String)mdcValue);
                    continue;
                }
                MDC.remove((String)key);
            }
        }

        @Override
        public void setValue() {
            for (String key : this.keys) {
                MDC.remove((String)key);
            }
        }
    }
}

