/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.examples.ModRate;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.ValuePattern;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class ModRateThread
extends Thread {
    @NotNull
    private final AtomicBoolean stopRequested;
    @NotNull
    private final AtomicInteger runningThreads;
    @NotNull
    private final AtomicLong errorCounter;
    @NotNull
    private final AtomicLong modCounter;
    @NotNull
    private final AtomicLong modDurations;
    @Nullable
    private final AtomicLong remainingIterationsBeforeReconnect;
    @NotNull
    private final AtomicReference<ResultCode> resultCode;
    private final boolean increment;
    @NotNull
    private final Control[] modifyControls;
    @NotNull
    private final CyclicBarrier startBarrier;
    @Nullable
    private final FixedRateBarrier fixedRateBarrier;
    private final int incrementAmount;
    private final int valueCount;
    @Nullable
    private LDAPConnection connection;
    private final long iterationsBeforeReconnect;
    @NotNull
    private final ModRate modRate;
    @NotNull
    private final ResultCodeCounter rcCounter;
    @NotNull
    private final String[] attributes;
    @NotNull
    private final AtomicReference<Thread> modThread;
    @Nullable
    private final ValuePattern authzID;
    @NotNull
    private final ValuePattern entryDN;
    @NotNull
    private final ValuePattern valuePattern;

    ModRateThread(@NotNull ModRate modRate, int threadNumber, @NotNull LDAPConnection connection, @NotNull ValuePattern entryDN, @NotNull String[] attributes, @NotNull ValuePattern valuePattern, int valueCount, boolean increment, int incrementAmount, @NotNull Control[] modifyControls, @Nullable ValuePattern authzID, long iterationsBeforeReconnect, @NotNull AtomicInteger runningThreads, @NotNull CyclicBarrier startBarrier, @NotNull AtomicLong modCounter, @NotNull AtomicLong modDurations, @NotNull AtomicLong errorCounter, @NotNull ResultCodeCounter rcCounter, @Nullable FixedRateBarrier rateBarrier) {
        this.setName("ModRate Thread " + threadNumber);
        this.setDaemon(true);
        this.modRate = modRate;
        this.connection = connection;
        this.entryDN = entryDN;
        this.attributes = attributes;
        this.valuePattern = valuePattern;
        this.valueCount = valueCount;
        this.increment = increment;
        this.incrementAmount = incrementAmount;
        this.modifyControls = modifyControls;
        this.authzID = authzID;
        this.iterationsBeforeReconnect = iterationsBeforeReconnect;
        this.modCounter = modCounter;
        this.modDurations = modDurations;
        this.errorCounter = errorCounter;
        this.rcCounter = rcCounter;
        this.runningThreads = runningThreads;
        this.startBarrier = startBarrier;
        this.fixedRateBarrier = rateBarrier;
        this.remainingIterationsBeforeReconnect = iterationsBeforeReconnect > 0L ? new AtomicLong(iterationsBeforeReconnect) : null;
        connection.setConnectionName("mod-" + threadNumber);
        this.resultCode = new AtomicReference<Object>(null);
        this.modThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.modThread.set(ModRateThread.currentThread());
            this.runningThreads.incrementAndGet();
            Modification[] mods = new Modification[this.attributes.length];
            String[] values = new String[this.valueCount];
            if (this.increment) {
                values[0] = String.valueOf(this.incrementAmount);
                for (int i = 0; i < this.attributes.length; ++i) {
                    mods[i] = new Modification(ModificationType.INCREMENT, this.attributes[i], values);
                }
            }
            ModifyRequest modifyRequest = new ModifyRequest("", mods);
            try {
                this.startBarrier.await();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            while (!this.stopRequested.get()) {
                long startTime;
                block21: {
                    if (this.iterationsBeforeReconnect > 0L && this.remainingIterationsBeforeReconnect.decrementAndGet() <= 0L) {
                        this.remainingIterationsBeforeReconnect.set(this.iterationsBeforeReconnect);
                        if (this.connection != null) {
                            this.connection.close();
                            this.connection = null;
                        }
                    }
                    if (this.connection == null) {
                        try {
                            this.connection = this.modRate.getConnection();
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.errorCounter.incrementAndGet();
                            ResultCode rc = le.getResultCode();
                            this.rcCounter.increment(rc);
                            this.resultCode.compareAndSet(null, rc);
                            if (this.fixedRateBarrier == null) continue;
                            this.fixedRateBarrier.await();
                            continue;
                        }
                    }
                    modifyRequest.setDN(this.entryDN.nextValue());
                    if (!this.increment) {
                        int i;
                        for (i = 0; i < this.valueCount; ++i) {
                            values[i] = this.valuePattern.nextValue();
                        }
                        for (i = 0; i < this.attributes.length; ++i) {
                            mods[i] = new Modification(ModificationType.REPLACE, this.attributes[i], values);
                        }
                        modifyRequest.setModifications(mods);
                    }
                    modifyRequest.setControls(this.modifyControls);
                    if (this.authzID != null) {
                        modifyRequest.addControl(new ProxiedAuthorizationV2RequestControl(this.authzID.nextValue()));
                    }
                    if (this.fixedRateBarrier != null) {
                        this.fixedRateBarrier.await();
                    }
                    startTime = System.nanoTime();
                    try {
                        this.connection.modify(modifyRequest);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.errorCounter.incrementAndGet();
                        ResultCode rc = le.getResultCode();
                        this.rcCounter.increment(rc);
                        this.resultCode.compareAndSet(null, rc);
                        if (le.getResultCode().isConnectionUsable()) break block21;
                        this.connection.close();
                        this.connection = null;
                    }
                }
                this.modCounter.incrementAndGet();
                this.modDurations.addAndGet(System.nanoTime() - startTime);
            }
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
            this.modThread.set(null);
            this.runningThreads.decrementAndGet();
        }
    }

    @NotNull
    public ResultCode stopRunning() {
        block4: {
            Thread t = this.modThread.get();
            this.stopRequested.set(true);
            if (this.fixedRateBarrier != null) {
                this.fixedRateBarrier.shutdownRequested();
            }
            if (t != null) {
                try {
                    t.join();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (!(e instanceof InterruptedException)) break block4;
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }
}

