/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.adapter.mailbox.MailboxCopierManagementMBean;
import org.apache.james.adapter.mailbox.MailboxManagerResolver;
import org.apache.james.adapter.mailbox.MailboxManagerResolverException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.copier.MailboxCopier;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.OverQuotaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxCopierManagement
implements MailboxCopierManagementMBean {
    private static final Logger log = LoggerFactory.getLogger((String)MailboxCopierManagement.class.getName());
    private MailboxCopier copier;
    private MailboxManagerResolver resolver;

    @Inject
    public void setMailboxCopier(@Named(value="mailboxcopier") MailboxCopier copier) {
        this.copier = copier;
    }

    @Inject
    public void setMailboxManagerResolver(MailboxManagerResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public Map<String, String> getMailboxManagerBeans() {
        HashMap<String, String> bMap = new HashMap<String, String>();
        Map<String, MailboxManager> beans = this.resolver.getMailboxManagerBeans();
        for (Map.Entry<String, MailboxManager> entry : beans.entrySet()) {
            String name = entry.getValue().getClass().getName();
            bMap.put(entry.getKey(), name);
        }
        return bMap;
    }

    @Override
    public void copy(String srcBean, String dstBean) throws Exception {
        if (srcBean.equals(dstBean)) {
            throw new IllegalArgumentException("srcBean and dstBean can not have the same name!");
        }
        try {
            this.copier.copyMailboxes(this.resolver.resolveMailboxManager(srcBean), this.resolver.resolveMailboxManager(dstBean));
        }
        catch (OverQuotaException e) {
            log.error("An over quota occured during the copy process", (Throwable)e);
            throw new Exception(e.getMessage());
        }
        catch (IOException | MailboxManagerResolverException | MailboxException e) {
            log.error("An exception occured during the copy process", e);
            throw new Exception(e.getMessage());
        }
    }
}

