/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.sys;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.base.file.FileSet;

public class FileRef {
    private final String filename;
    private final int id;
    static final int idxOffset = 10;
    static final String journalName = "journal";
    static final int journalIdx = 9;
    static Map<String, Integer> name2id = new HashMap<String, Integer>();
    static Map<Integer, FileRef> id2name = new TreeMap<Integer, FileRef>();
    public static final FileRef Journal;

    public static void register(String fn) {
        FileRef.file(fn);
    }

    private static void add(int idx, String fn) {
        name2id.put(fn, idx);
        id2name.put(idx, new FileRef(fn, idx));
    }

    private static void bTree(String name) {
        FileRef.file(name + ".idn");
        FileRef.file(name + ".dat");
    }

    public static void file(String name) {
        int idx = name2id.size() + 10;
        FileRef.add(idx, name);
    }

    public static FileRef create(FileSet fileSet, String ext) {
        return FileRef.create(fileSet.filename(ext));
    }

    public static FileRef create(String filename) {
        Tuple<String> x = FileOps.splitDirFile(filename);
        String key = x.get(1);
        if (!name2id.containsKey(key)) {
            Log.debug(FileRef.class, "File name not registered: " + filename);
            FileRef.file(key);
        }
        return new FileRef(key, name2id.get(key));
    }

    public static FileRef get(int fileId) {
        FileRef f = id2name.get(fileId);
        if (f == null) {
            Log.error(FileRef.class, "No FileRef registered for id: " + fileId);
            throw new TDB1Exception("No FileRef registered for id: " + fileId);
        }
        return f;
    }

    private FileRef(String filename, int id) {
        if (filename == null) {
            throw new IllegalArgumentException("Null for a FileRef filename");
        }
        this.filename = filename.intern();
        this.id = id;
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        return "fileref(" + this.id + "):" + this.filename;
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileRef other = (FileRef)obj;
        if (this.id != other.id) {
            return false;
        }
        return Objects.equals(this.filename, other.filename);
    }

    static {
        FileRef.add(9, journalName);
        FileRef.file("SPO.idn");
        FileRef.file("SPO.dat");
        FileRef.file("POS.idn");
        FileRef.file("POS.dat");
        FileRef.file("OSP.idn");
        FileRef.file("OSP.dat");
        FileRef.file("GSPO.idn");
        FileRef.file("GSPO.dat");
        FileRef.file("GPOS.idn");
        FileRef.file("GPOS.dat");
        FileRef.file("GOSP.idn");
        FileRef.file("GOSP.dat");
        FileRef.file("POSG.idn");
        FileRef.file("POSG.dat");
        FileRef.file("OSPG.idn");
        FileRef.file("OSPG.dat");
        FileRef.file("SPOG.idn");
        FileRef.file("SPOG.dat");
        FileRef.file("prefixes.idn");
        FileRef.file("prefixes.dat");
        FileRef.file("prefix2id.idn");
        FileRef.file("prefix2id.dat");
        FileRef.file("nodes.dat");
        FileRef.file("node2id.idn");
        FileRef.file("node2id.dat");
        FileRef.file("prefixIdx.idn");
        FileRef.file("prefixIdx.dat");
        FileRef.add(1010, "TEST");
        FileRef.add(1011, "TEST1");
        FileRef.add(1012, "TEST2");
        Journal = FileRef.get(9);
    }
}

