/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.facetset;

import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.util.BytesRef;

public interface FacetSetDecoder {
    public static int decodeLongs(BytesRef bytesRef, int start, long[] dest) {
        LongPoint.unpack(bytesRef, start, dest);
        return dest.length * 8;
    }

    public static int decodeInts(BytesRef bytesRef, int start, long[] dest) {
        int i = 0;
        int offset = start;
        while (i < dest.length) {
            dest[i] = IntPoint.decodeDimension(bytesRef.bytes, offset);
            ++i;
            offset += 4;
        }
        return dest.length * 4;
    }

    public int decode(BytesRef var1, int var2, long[] var3);
}

