/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.sandbox.search.CombinedFieldQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SmallFloat;

final class MultiNormsLeafSimScorer {
    private static final float[] LENGTH_TABLE = new float[256];
    private final Similarity.SimScorer scorer;
    private final NumericDocValues norms;

    MultiNormsLeafSimScorer(Similarity.SimScorer scorer, LeafReader reader, Collection<CombinedFieldQuery.FieldAndWeight> normFields, boolean needsScores) throws IOException {
        this.scorer = Objects.requireNonNull(scorer);
        if (needsScores) {
            ArrayList<NumericDocValues> normsList = new ArrayList<NumericDocValues>();
            ArrayList<Float> weightList = new ArrayList<Float>();
            HashSet<String> duplicateCheckingSet = new HashSet<String>();
            for (CombinedFieldQuery.FieldAndWeight field : normFields) {
                assert (duplicateCheckingSet.add(field.field())) : "There is a duplicated field [" + field.field() + "] used to construct MultiNormsLeafSimScorer";
                NumericDocValues norms = reader.getNormValues(field.field());
                if (norms == null) continue;
                normsList.add(norms);
                weightList.add(Float.valueOf(field.weight()));
            }
            if (normsList.isEmpty()) {
                this.norms = null;
            } else {
                NumericDocValues[] normsArr = normsList.toArray(new NumericDocValues[0]);
                float[] weightArr = new float[normsList.size()];
                for (int i = 0; i < weightList.size(); ++i) {
                    weightArr[i] = ((Float)weightList.get(i)).floatValue();
                }
                this.norms = new MultiFieldNormValues(normsArr, weightArr);
            }
        } else {
            this.norms = null;
        }
    }

    Similarity.SimScorer getSimScorer() {
        return this.scorer;
    }

    private long getNormValue(int doc) throws IOException {
        if (this.norms != null) {
            boolean found = this.norms.advanceExact(doc);
            assert (found);
            return this.norms.longValue();
        }
        return 1L;
    }

    public float score(int doc, float freq) throws IOException {
        return this.scorer.score(freq, this.getNormValue(doc));
    }

    public Explanation explain(int doc, Explanation freqExpl) throws IOException {
        return this.scorer.explain(freqExpl, this.getNormValue(doc));
    }

    static {
        for (int i = 0; i < 256; ++i) {
            MultiNormsLeafSimScorer.LENGTH_TABLE[i] = SmallFloat.byte4ToInt((byte)i);
        }
    }

    private static class MultiFieldNormValues
    extends NumericDocValues {
        private final NumericDocValues[] normsArr;
        private final float[] weightArr;
        private long current;
        private int docID = -1;

        MultiFieldNormValues(NumericDocValues[] normsArr, float[] weightArr) {
            this.normsArr = normsArr;
            this.weightArr = weightArr;
        }

        @Override
        public long longValue() {
            return this.current;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            float normValue = 0.0f;
            boolean found = false;
            for (int i = 0; i < this.normsArr.length; ++i) {
                if (!this.normsArr[i].advanceExact(target)) continue;
                normValue += this.weightArr[i] * LENGTH_TABLE[Byte.toUnsignedInt((byte)this.normsArr[i].longValue())];
                found = true;
            }
            this.current = SmallFloat.intToByte4(Math.round(normValue));
            return found;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }
    }
}

