/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.http.NameValuePair;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.Enablement;
import org.apache.juneau.MediaType;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.ContextBeanCreator;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderSet;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.part.PartList;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserSet;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpInvoker;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.annotation.RestDelete;
import org.apache.juneau.rest.annotation.RestGet;
import org.apache.juneau.rest.annotation.RestInject;
import org.apache.juneau.rest.annotation.RestOp;
import org.apache.juneau.rest.annotation.RestPost;
import org.apache.juneau.rest.annotation.RestPut;
import org.apache.juneau.rest.common.utils.HttpUtils;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.rest.converter.RestConverterList;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.rest.guard.RestGuard;
import org.apache.juneau.rest.guard.RestGuardList;
import org.apache.juneau.rest.guard.RoleBasedRestGuard;
import org.apache.juneau.rest.httppart.NamedAttribute;
import org.apache.juneau.rest.httppart.NamedAttributeMap;
import org.apache.juneau.rest.httppart.ResponsePartMeta;
import org.apache.juneau.rest.logger.CallLogger;
import org.apache.juneau.rest.matcher.ClientVersionMatcher;
import org.apache.juneau.rest.matcher.RestMatcher;
import org.apache.juneau.rest.matcher.RestMatcherList;
import org.apache.juneau.rest.util.DefaultClassList;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathMatch;
import org.apache.juneau.rest.util.UrlPathMatcher;
import org.apache.juneau.rest.util.UrlPathMatcherList;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSet;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public class RestOpContext
extends Context
implements Comparable<RestOpContext> {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    protected final boolean dotAll;
    protected final int hierarchyDepth;
    protected final long maxInput;
    protected final BeanContext beanContext;
    protected final CallLogger callLogger;
    protected final Charset defaultCharset;
    protected final DebugEnablement debug;
    protected final EncoderSet encoders;
    protected final HeaderList defaultRequestHeaders;
    protected final HeaderList defaultResponseHeaders;
    protected final HttpPartParser partParser;
    protected final HttpPartSerializer partSerializer;
    protected final JsonSchemaGenerator jsonSchemaGenerator;
    protected final List<MediaType> supportedAcceptTypes;
    protected final List<MediaType> supportedContentTypes;
    protected final Map<Class<?>, ResponseBeanMeta> responseBeanMetas = new ConcurrentHashMap();
    protected final Map<Class<?>, ResponsePartMeta> headerPartMetas = new ConcurrentHashMap();
    protected final Method method;
    protected final MethodInfo mi;
    protected final NamedAttributeMap defaultRequestAttributes;
    protected final PartList defaultRequestFormData;
    protected final PartList defaultRequestQueryData;
    protected final ParserSet parsers;
    protected final RestContext context;
    protected final RestConverter[] converters;
    protected final RestGuard[] guards;
    protected final RestMatcher[] optionalMatchers;
    protected final RestMatcher[] requiredMatchers;
    protected final RestOpInvoker methodInvoker;
    protected final RestOpInvoker[] postCallMethods;
    protected final RestOpInvoker[] preCallMethods;
    protected final ResponseBeanMeta responseMeta;
    protected final SerializerSet serializers;
    protected final String httpMethod;
    protected final UrlPathMatcher[] pathMatchers;

    public static Builder create(Method method, RestContext context) {
        return new Builder(method, context);
    }

    private static HttpPartSerializer createPartSerializer(Class<? extends HttpPartSerializer> c, HttpPartSerializer _default) {
        return (HttpPartSerializer)BeanCreator.of(HttpPartSerializer.class).type(c).orElse((Object)_default);
    }

    protected RestOpContext(Builder builder) throws ServletException {
        super((Context.Builder)builder);
        try {
            this.context = builder.restContext;
            this.method = builder.restMethod;
            this.debug = builder.debug == null ? this.context.getDebugEnablement() : DebugEnablement.create(this.context.getBeanStore()).enable(builder.debug, "*").build();
            this.mi = MethodInfo.of((Method)this.method).accessible();
            Object r = this.context.getResource();
            BeanStore bs = BeanStore.of((BeanStore)this.context.getRootBeanStore(), (Object)r).addBean(RestOpContext.class, (Object)this).addBean(Method.class, (Object)this.method).addBean(AnnotationWorkList.class, (Object)builder.getApplied());
            bs.addBean(BeanStore.class, (Object)bs);
            this.beanContext = (BeanContext)bs.add(BeanContext.class, (Object)builder.getBeanContext().orElse(this.context.getBeanContext()));
            this.converters = (RestConverter[])bs.add(RestConverter[].class, (Object)((RestConverterList)builder.converters().build()).asArray());
            this.encoders = (EncoderSet)bs.add(EncoderSet.class, (Object)builder.getEncoders().orElse(this.context.getEncoders()));
            this.guards = (RestGuard[])bs.add(RestGuard[].class, (Object)builder.getGuards().asArray());
            this.jsonSchemaGenerator = (JsonSchemaGenerator)bs.add(JsonSchemaGenerator.class, (Object)builder.getJsonSchemaGenerator().orElse(this.context.getJsonSchemaGenerator()));
            this.parsers = (ParserSet)bs.add(ParserSet.class, (Object)builder.getParsers().orElse(this.context.getParsers()));
            this.partParser = (HttpPartParser)bs.add(HttpPartParser.class, (Object)builder.getPartParser().orElse(this.context.getPartParser()));
            this.partSerializer = (HttpPartSerializer)bs.add(HttpPartSerializer.class, (Object)builder.getPartSerializer().orElse(this.context.getPartSerializer()));
            this.serializers = (SerializerSet)bs.add(SerializerSet.class, (Object)builder.getSerializers().orElse(this.context.getSerializers()));
            RestMatcherList matchers = builder.getMatchers(this.context);
            this.optionalMatchers = matchers.getOptionalEntries();
            this.requiredMatchers = matchers.getRequiredEntries();
            this.pathMatchers = (UrlPathMatcher[])bs.add(UrlPathMatcher[].class, (Object)builder.getPathMatchers().asArray());
            bs.addBean(UrlPathMatcher.class, this.pathMatchers.length > 0 ? this.pathMatchers[0] : null);
            this.supportedAcceptTypes = CollectionUtils.u((List)(Utils.nn(builder.produces) ? builder.produces : this.serializers.getSupportedMediaTypes()));
            this.supportedContentTypes = CollectionUtils.u((List)(Utils.nn(builder.consumes) ? builder.consumes : this.parsers.getSupportedMediaTypes()));
            this.defaultRequestAttributes = builder.defaultRequestAttributes();
            this.defaultRequestFormData = builder.defaultRequestFormData();
            this.defaultRequestHeaders = builder.defaultRequestHeaders();
            this.defaultRequestQueryData = builder.defaultRequestQueryData();
            this.defaultResponseHeaders = builder.defaultResponseHeaders();
            int _hierarchyDepth = 0;
            Class<?> sc = this.method.getDeclaringClass().getSuperclass();
            while (Utils.nn(sc)) {
                ++_hierarchyDepth;
                sc = sc.getSuperclass();
            }
            this.hierarchyDepth = _hierarchyDepth;
            String _httpMethod = builder.httpMethod;
            if (_httpMethod == null) {
                _httpMethod = HttpUtils.detectHttpMethod((Method)this.method, (boolean)true, (String)"GET");
            }
            if ("METHOD".equals(_httpMethod)) {
                _httpMethod = "*";
            }
            this.httpMethod = _httpMethod.toUpperCase(Locale.ENGLISH);
            this.defaultCharset = Utils.nn((Object)builder.defaultCharset) ? builder.defaultCharset : this.context.defaultCharset;
            this.dotAll = builder.dotAll;
            this.maxInput = Utils.nn((Object)builder.maxInput) ? builder.maxInput : this.context.maxInput;
            this.responseMeta = ResponseBeanMeta.create((MethodInfo)this.mi, (AnnotationWorkList)builder.getApplied());
            this.preCallMethods = (RestOpInvoker[])this.context.getPreCallMethods().stream().map(x -> new RestOpInvoker((Method)x, this.context.findRestOperationArgs((Method)x, bs), this.context.getMethodExecStats((Method)x))).toArray(RestOpInvoker[]::new);
            this.postCallMethods = (RestOpInvoker[])this.context.getPostCallMethods().stream().map(x -> new RestOpInvoker((Method)x, this.context.findRestOperationArgs((Method)x, bs), this.context.getMethodExecStats((Method)x))).toArray(RestOpInvoker[]::new);
            this.methodInvoker = new RestOpInvoker(this.method, this.context.findRestOperationArgs(this.method, bs), this.context.getMethodExecStats(this.method));
            this.callLogger = this.context.getCallLogger();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public int compareTo(RestOpContext o) {
        int c;
        int i;
        for (i = 0; i < Math.min(this.pathMatchers.length, o.pathMatchers.length); ++i) {
            c = this.pathMatchers[i].compareTo(o.pathMatchers[i]);
            if (c == 0) continue;
            return c;
        }
        c = Utils.cmp((Object)o.hierarchyDepth, (Object)this.hierarchyDepth);
        if (c != 0) {
            return c;
        }
        c = Utils.cmp((Object)o.requiredMatchers.length, (Object)this.requiredMatchers.length);
        if (c != 0) {
            return c;
        }
        c = Utils.cmp((Object)o.optionalMatchers.length, (Object)this.optionalMatchers.length);
        if (c != 0) {
            return c;
        }
        c = Utils.cmp((Object)o.guards.length, (Object)this.guards.length);
        if (c != 0) {
            return c;
        }
        c = Utils.cmp((Object)this.method.getName(), (Object)o.method.getName());
        if (c != 0) {
            return c;
        }
        c = Utils.cmp((Object)this.method.getParameterCount(), (Object)o.method.getParameterCount());
        if (c != 0) {
            return c;
        }
        for (i = 0; i < this.method.getParameterCount(); ++i) {
            c = Utils.cmp((Object)this.method.getParameterTypes()[i].getName(), (Object)o.method.getParameterTypes()[i].getName());
            if (c == 0) continue;
            return c;
        }
        c = Utils.cmp((Object)this.method.getReturnType().getName(), (Object)o.method.getReturnType().getName());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public Context.Builder copy() {
        throw ThrowableUtils.unsupportedOp();
    }

    public RestRequest createRequest(RestSession session) throws Exception {
        return new RestRequest(this, session);
    }

    public RestResponse createResponse(RestSession session, RestRequest req) throws Exception {
        return new RestResponse(this, session, req);
    }

    public RestOpSession.Builder createSession(RestSession session) throws Exception {
        return RestOpSession.create(this, session).logger(this.callLogger).debug(this.debug.isDebug(this, session.getRequest()));
    }

    public boolean equals(Object o) {
        RestOpContext o2;
        return o instanceof RestOpContext && Utils.eq((Object)this, (Object)(o2 = (RestOpContext)o), (x, y) -> Utils.eq((Object)x.method, (Object)y.method));
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public NamedAttributeMap getDefaultRequestAttributes() {
        return this.defaultRequestAttributes;
    }

    public PartList getDefaultRequestFormData() {
        return this.defaultRequestFormData;
    }

    public HeaderList getDefaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    public PartList getDefaultRequestQueryData() {
        return this.defaultRequestQueryData;
    }

    public HeaderList getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    public EncoderSet getEncoders() {
        return this.encoders;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public Method getJavaMethod() {
        return this.method;
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.jsonSchemaGenerator;
    }

    public long getMaxInput() {
        return this.maxInput;
    }

    public ParserSet getParsers() {
        return this.parsers;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public String getPathPattern() {
        return this.pathMatchers[0].toString();
    }

    public ResponseBeanMeta getResponseBeanMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponseBeanMeta rbm = this.responseBeanMetas.get(c);
        if (rbm == null) {
            rbm = ResponseBeanMeta.create(c, (AnnotationWorkList)AnnotationWorkList.create());
            if (rbm == null) {
                rbm = ResponseBeanMeta.NULL;
            }
            this.responseBeanMetas.put(c, rbm);
        }
        if (rbm == ResponseBeanMeta.NULL) {
            return null;
        }
        return rbm;
    }

    public ResponsePartMeta getResponseHeaderMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponsePartMeta pm = this.headerPartMetas.get(c);
        if (pm == null) {
            Header a = ClassInfo.of(c).getAnnotations(Header.class).findFirst().map(AnnotationInfo::inner).orElse(null);
            if (Utils.nn((Object)a)) {
                HttpPartSchema schema = HttpPartSchema.create((Annotation)a);
                HttpPartSerializer serializer = RestOpContext.createPartSerializer(schema.getSerializer(), this.partSerializer);
                pm = new ResponsePartMeta(HttpPartType.HEADER, schema, serializer);
            }
            if (pm == null) {
                pm = ResponsePartMeta.NULL;
            }
            this.headerPartMetas.put(c, pm);
        }
        if (pm == ResponsePartMeta.NULL) {
            return null;
        }
        return pm;
    }

    public ResponseBeanMeta getResponseMeta() {
        return this.responseMeta;
    }

    public SerializerSet getSerializers() {
        return this.serializers;
    }

    public List<MediaType> getSupportedAcceptTypes() {
        return this.supportedAcceptTypes;
    }

    public List<MediaType> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    private UrlPathMatch matchPattern(RestSession call) {
        UrlPathMatch pm = null;
        for (UrlPathMatcher pp : this.pathMatchers) {
            if (pm != null) continue;
            pm = pp.match(call.getUrlPath());
        }
        return pm;
    }

    protected int match(RestSession session) {
        UrlPathMatch pm = this.matchPattern(session);
        if (pm == null) {
            return 0;
        }
        if (this.requiredMatchers.length == 0 && this.optionalMatchers.length == 0) {
            session.urlPathMatch(pm);
            return 2;
        }
        try {
            HttpServletRequest req = session.getRequest();
            for (RestMatcher m : this.requiredMatchers) {
                if (m.matches(req)) continue;
                return 1;
            }
            if (this.optionalMatchers.length > 0) {
                boolean matches = false;
                for (RestMatcher m : this.optionalMatchers) {
                    matches |= m.matches(req);
                }
                if (!matches) {
                    return 1;
                }
            }
            session.urlPathMatch(pm);
            return 2;
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e);
        }
    }

    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"defaultRequestFormData", (Object)this.defaultRequestFormData).a((Object)"defaultRequestHeaders", (Object)this.defaultRequestHeaders).a((Object)"defaultRequestQueryData", (Object)this.defaultRequestQueryData).a((Object)"httpMethod", (Object)this.httpMethod);
    }

    RestConverter[] getConverters() {
        return this.converters;
    }

    RestGuard[] getGuards() {
        return this.guards;
    }

    RestOpInvoker getMethodInvoker() {
        return this.methodInvoker;
    }

    RestOpInvoker[] getPostCallMethods() {
        return this.postCallMethods;
    }

    RestOpInvoker[] getPreCallMethods() {
        return this.preCallMethods;
    }

    public static class Builder
    extends Context.Builder {
        private BeanContext.Builder beanContext;
        private BeanStore beanStore;
        private boolean dotAll;
        private Charset defaultCharset;
        private EncoderSet.Builder encoders;
        private Enablement debug;
        private HeaderList defaultRequestHeaders;
        private HeaderList defaultResponseHeaders;
        private HttpPartParser.Creator partParser;
        private HttpPartSerializer.Creator partSerializer;
        private JsonSchemaGenerator.Builder jsonSchemaGenerator;
        private List<MediaType> consumes;
        private List<MediaType> produces;
        private List<String> path;
        private Long maxInput;
        private Method restMethod;
        private NamedAttributeMap defaultRequestAttributes;
        private ParserSet.Builder parsers;
        private PartList defaultRequestFormData;
        private PartList defaultRequestQueryData;
        private RestContext restContext;
        private RestContext.Builder parent;
        private RestConverterList.Builder converters;
        private RestGuardList.Builder guards;
        private RestMatcherList.Builder matchers;
        private SerializerSet.Builder serializers;
        private Set<String> roleGuard;
        private Set<String> rolesDeclared;
        private String clientVersion;
        private String httpMethod;

        Builder(Method method, RestContext context) {
            this.restContext = context;
            this.parent = context.builder;
            this.restMethod = method;
            this.beanStore = BeanStore.of((BeanStore)context.getBeanStore(), context.builder.resource().get()).addBean(Method.class, (Object)method);
            AnnotationProvider ap = context.getBeanContext().getAnnotationProvider();
            MethodInfo mi = MethodInfo.of(context.getResourceClass(), (Method)method);
            try {
                VarResolver vr = context.getVarResolver();
                VarResolverSession vrs = vr.createSession();
                AnnotationWorkList work = AnnotationWorkList.of((VarResolverSession)vrs, CollectionUtils.rstream((List)ap.find(mi, new AnnotationTraversal[]{AnnotationTraversal.SELF, AnnotationTraversal.MATCHING_METHODS, AnnotationTraversal.DECLARING_CLASS, AnnotationTraversal.RETURN_TYPE, AnnotationTraversal.PACKAGE})).filter(Context.CONTEXT_APPLY_FILTER));
                this.apply(work);
                if (context.builder.beanContext().canApply(work)) {
                    this.beanContext().apply(work);
                }
                if (context.builder.serializers().canApply(work)) {
                    this.serializers().apply(work);
                }
                if (context.builder.parsers().canApply(work)) {
                    this.parsers().apply(work);
                }
                if (context.builder.partSerializer().canApply(work)) {
                    this.partSerializer().apply(work);
                }
                if (context.builder.partParser().canApply(work)) {
                    this.partParser().apply(work);
                }
                if (context.builder.jsonSchemaGenerator().canApply(work)) {
                    this.jsonSchemaGenerator().apply(work);
                }
                this.processParameterAnnotations();
            }
            catch (Exception e) {
                throw new InternalServerError((Throwable)e);
            }
        }

        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        public BeanContext.Builder beanContext() {
            if (this.beanContext == null) {
                this.beanContext = this.createBeanContext(this.beanStore(), this.parent, this.resource());
            }
            return this.beanContext;
        }

        public BeanStore beanStore() {
            return this.beanStore;
        }

        public <T> Builder beanStore(Class<T> beanType, T bean) {
            this.beanStore().addBean((Class)AssertionUtils.assertArgNotNull((String)"beanType", beanType), bean);
            return this;
        }

        public <T> Builder beanStore(Class<T> beanType, T bean, String name) {
            this.beanStore().addBean((Class)AssertionUtils.assertArgNotNull((String)"beanType", beanType), bean, name);
            return this;
        }

        public RestOpContext build() {
            try {
                return (RestOpContext)this.beanStore.createBean(RestOpContext.class).type(this.getType().orElse(this.getDefaultImplClass())).builder(Builder.class, (Object)this).run();
            }
            catch (Exception e) {
                throw new InternalServerError((Throwable)e);
            }
        }

        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        public Builder clientVersion(String value) {
            this.clientVersion = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder consumes(MediaType ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.consumes = CollectionUtils.addAll(this.consumes, (Object[])values);
            return this;
        }

        public RestConverterList.Builder converters() {
            if (this.converters == null) {
                this.converters = this.createConverters(this.beanStore(), this.resource());
            }
            return this.converters;
        }

        @SafeVarargs
        public final Builder converters(Class<? extends RestConverter> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.converters().append(value);
            return this;
        }

        public Builder converters(RestConverter ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.converters().append(value);
            return this;
        }

        public Builder copy() {
            throw new NoSuchMethodError("Not implemented.");
        }

        public Builder debug() {
            super.debug();
            return this;
        }

        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder debug(Enablement value) {
            this.debug = (Enablement)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder defaultCharset(Charset value) {
            this.defaultCharset = (Charset)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public DefaultClassList defaultClasses() {
            return this.restContext.builder.defaultClasses();
        }

        public NamedAttributeMap defaultRequestAttributes() {
            if (this.defaultRequestAttributes == null) {
                this.defaultRequestAttributes = this.createDefaultRequestAttributes(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestAttributes;
        }

        public Builder defaultRequestAttributes(NamedAttribute ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.defaultRequestAttributes().add(value);
            return this;
        }

        public PartList defaultRequestFormData() {
            if (this.defaultRequestFormData == null) {
                this.defaultRequestFormData = this.createDefaultRequestFormData(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestFormData;
        }

        public Builder defaultRequestFormData(NameValuePair ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.defaultRequestFormData().append(value);
            return this;
        }

        public HeaderList defaultRequestHeaders() {
            if (this.defaultRequestHeaders == null) {
                this.defaultRequestHeaders = this.createDefaultRequestHeaders(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestHeaders;
        }

        public Builder defaultRequestHeaders(org.apache.http.Header ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.defaultRequestHeaders().append(value);
            return this;
        }

        public PartList defaultRequestQueryData() {
            if (this.defaultRequestQueryData == null) {
                this.defaultRequestQueryData = this.createDefaultRequestQueryData(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestQueryData;
        }

        public Builder defaultRequestQueryData(NameValuePair ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.defaultRequestQueryData().append(value);
            return this;
        }

        public HeaderList defaultResponseHeaders() {
            if (this.defaultResponseHeaders == null) {
                this.defaultResponseHeaders = this.createDefaultResponseHeaders(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultResponseHeaders;
        }

        public Builder defaultResponseHeaders(org.apache.http.Header ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.defaultResponseHeaders().append(value);
            return this;
        }

        public Builder dotAll() {
            this.dotAll = true;
            return this;
        }

        public EncoderSet.Builder encoders() {
            if (this.encoders == null) {
                this.encoders = this.createEncoders(this.beanStore(), this.parent, this.resource());
            }
            return this.encoders;
        }

        @SafeVarargs
        public final Builder encoders(Class<? extends Encoder> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.encoders().add((Class[])value);
            return this;
        }

        public Builder encoders(Encoder ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.encoders().add(value);
            return this;
        }

        public RestGuardList.Builder guards() {
            if (this.guards == null) {
                this.guards = this.createGuards(this.beanStore(), this.resource());
            }
            return this.guards;
        }

        @SafeVarargs
        public final Builder guards(Class<? extends RestGuard> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.guards().append(value);
            return this;
        }

        public Builder guards(RestGuard ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.guards().append(value);
            return this;
        }

        public Builder httpMethod(String value) {
            this.httpMethod = (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public JsonSchemaGenerator.Builder jsonSchemaGenerator() {
            if (this.jsonSchemaGenerator == null) {
                this.jsonSchemaGenerator = this.createJsonSchemaGenerator(this.beanStore(), this.parent, this.resource());
            }
            return this.jsonSchemaGenerator;
        }

        public Builder jsonSchemaGenerator(Class<? extends JsonSchemaGenerator> value) {
            this.jsonSchemaGenerator().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder jsonSchemaGenerator(JsonSchemaGenerator value) {
            this.jsonSchemaGenerator().impl((Context)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public RestMatcherList.Builder matchers() {
            if (this.matchers == null) {
                this.matchers = this.createMatchers(this.beanStore(), this.resource());
            }
            return this.matchers;
        }

        @SafeVarargs
        public final Builder matchers(Class<? extends RestMatcher> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.matchers().append(value);
            return this;
        }

        public Builder matchers(RestMatcher ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.matchers().append(value);
            return this;
        }

        public Builder maxInput(String value) {
            this.maxInput = StringUtils.parseLongWithSuffix((String)((String)AssertionUtils.assertArgNotNull((String)"value", (Object)value)));
            return this;
        }

        public ParserSet.Builder parsers() {
            if (this.parsers == null) {
                this.parsers = this.createParsers(this.beanStore(), this.parent, this.resource());
            }
            return this.parsers;
        }

        @SafeVarargs
        public final Builder parsers(Class<? extends Parser> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.parsers().add((Class[])value);
            return this;
        }

        public Builder parsers(Parser ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.parsers().add(value);
            return this;
        }

        public HttpPartParser.Creator partParser() {
            if (this.partParser == null) {
                this.partParser = this.createPartParser(this.beanStore(), this.parent, this.resource());
            }
            return this.partParser;
        }

        public Builder partParser(Class<? extends HttpPartParser> value) {
            this.partParser().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder partParser(HttpPartParser value) {
            this.partParser().impl(AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public HttpPartSerializer.Creator partSerializer() {
            if (this.partSerializer == null) {
                this.partSerializer = this.createPartSerializer(this.beanStore(), this.parent, this.resource());
            }
            return this.partSerializer;
        }

        public Builder partSerializer(Class<? extends HttpPartSerializer> value) {
            this.partSerializer().type((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder partSerializer(HttpPartSerializer value) {
            this.partSerializer().impl(AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder path(String ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.path = CollectionUtils.prependAll(this.path, (Object[])values);
            return this;
        }

        public Builder produces(MediaType ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.produces = CollectionUtils.addAll(this.produces, (Object[])values);
            return this;
        }

        public Supplier<?> resource() {
            return this.restContext.builder.resource();
        }

        public Builder roleGuard(String value) {
            if (this.roleGuard == null) {
                this.roleGuard = CollectionUtils.set((Object[])new String[]{(String)AssertionUtils.assertArgNotNull((String)"value", (Object)value)});
            } else {
                this.roleGuard.add((String)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            }
            return this;
        }

        public Builder rolesDeclared(String ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.rolesDeclared = CollectionUtils.addAll(this.rolesDeclared, (Object[])values);
            return this;
        }

        public SerializerSet.Builder serializers() {
            if (this.serializers == null) {
                this.serializers = this.createSerializers(this.beanStore(), this.parent, this.resource());
            }
            return this.serializers;
        }

        @SafeVarargs
        public final Builder serializers(Class<? extends Serializer> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.serializers().add((Class[])value);
            return this;
        }

        public Builder serializers(Serializer ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.serializers().add(value);
            return this;
        }

        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        private static String joinnlFirstNonEmptyArray(String[] ... s) {
            for (Object[] objectArray : s) {
                if (objectArray.length <= 0) continue;
                return StringUtils.joinnl((Object[])objectArray);
            }
            return null;
        }

        private boolean matches(MethodInfo annotated) {
            RestInject a = annotated.getAnnotations(RestInject.class).findFirst().map(AnnotationInfo::inner).orElse(null);
            if (Utils.nn((Object)a)) {
                for (String n : a.methodScope()) {
                    if (!"*".equals(n) && !this.restMethod.getName().equals(n)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean matches(MethodInfo annotated, String beanName) {
            RestInject a = annotated.getAnnotations(RestInject.class).findFirst().map(AnnotationInfo::inner).orElse(null);
            if (Utils.nn((Object)a)) {
                if (!a.name().equals(beanName)) {
                    return false;
                }
                for (String n : a.methodScope()) {
                    if (!"*".equals(n) && !this.restMethod.getName().equals(n)) continue;
                    return true;
                }
            }
            return false;
        }

        protected Builder beanStore(BeanStore beanStore) {
            this.beanStore = beanStore;
            return this;
        }

        protected BeanContext.Builder createBeanContext(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.beanContext().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(BeanContext.Builder.class, (Object)((BeanContext.Builder)v.get())).createMethodFinder(BeanContext.class, resource).find(this::matches).run(x -> ((BeanContext.Builder)v.get()).impl((Context)x));
            return (BeanContext.Builder)v.get();
        }

        protected RestConverterList.Builder createConverters(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)RestConverterList.create(beanStore)));
            this.defaultClasses().get(RestConverterList.class).ifPresent(x -> ((RestConverterList.Builder)((Object)((Object)v.get()))).type((Class)x));
            beanStore.getBean(RestConverterList.class).ifPresent(x -> ((RestConverterList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(RestConverterList.class).addBean(RestConverterList.Builder.class, (Object)((RestConverterList.Builder)((Object)v.get()))).find(this::matches).run(x -> ((RestConverterList.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestConverterList.Builder)((Object)v.get());
        }

        protected NamedAttributeMap createDefaultRequestAttributes(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.defaultRequestAttributes().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(NamedAttributeMap.class, (Object)((NamedAttributeMap)v.get())).createMethodFinder(NamedAttributeMap.class, resource).find(x -> this.matches((MethodInfo)x, "defaultRequestAttributes")).run(x -> v.set(x));
            return (NamedAttributeMap)v.get();
        }

        protected PartList createDefaultRequestFormData(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)PartList.create());
            BeanStore.of((BeanStore)beanStore, resource).addBean(PartList.class, (Object)((PartList)v.get())).createMethodFinder(PartList.class, resource).find(x -> this.matches((MethodInfo)x, "defaultRequestFormData")).run(x -> v.set(x));
            return (PartList)v.get();
        }

        protected HeaderList createDefaultRequestHeaders(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.defaultRequestHeaders().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(HeaderList.class, (Object)((HeaderList)v.get())).createMethodFinder(HeaderList.class, resource).find(x -> this.matches((MethodInfo)x, "defaultRequestHeaders")).run(x -> v.set(x));
            return (HeaderList)v.get();
        }

        protected PartList createDefaultRequestQueryData(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)PartList.create());
            BeanStore.of((BeanStore)beanStore, resource).addBean(PartList.class, (Object)((PartList)v.get())).createMethodFinder(PartList.class, resource).find(x -> this.matches((MethodInfo)x, "defaultRequestQueryData")).run(x -> v.set(x));
            return (PartList)v.get();
        }

        protected HeaderList createDefaultResponseHeaders(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.defaultResponseHeaders().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(HeaderList.class, (Object)((HeaderList)v.get())).createMethodFinder(HeaderList.class, resource).find(x -> this.matches((MethodInfo)x, "defaultResponseHeaders")).run(x -> v.set(x));
            return (HeaderList)v.get();
        }

        protected EncoderSet.Builder createEncoders(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.encoders().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(EncoderSet.Builder.class, (Object)((EncoderSet.Builder)v.get())).createMethodFinder(EncoderSet.class, resource).find(this::matches).run(x -> ((EncoderSet.Builder)v.get()).impl(x));
            return (EncoderSet.Builder)v.get();
        }

        protected RestGuardList.Builder createGuards(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)RestGuardList.create(beanStore)));
            this.defaultClasses().get(RestGuardList.class).ifPresent(x -> ((RestGuardList.Builder)((Object)((Object)v.get()))).type((Class)x));
            beanStore.getBean(RestGuardList.class).ifPresent(x -> ((RestGuardList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(RestGuardList.class).addBean(RestGuardList.Builder.class, (Object)((RestGuardList.Builder)((Object)v.get()))).find(m -> this.matches((MethodInfo)m)).run(x -> ((RestGuardList.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestGuardList.Builder)((Object)v.get());
        }

        protected JsonSchemaGenerator.Builder createJsonSchemaGenerator(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.jsonSchemaGenerator().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(JsonSchemaGenerator.Builder.class, (Object)((JsonSchemaGenerator.Builder)v.get())).createMethodFinder(JsonSchemaGenerator.class, resource).find(this::matches).run(x -> ((JsonSchemaGenerator.Builder)v.get()).impl((Context)x));
            return (JsonSchemaGenerator.Builder)v.get();
        }

        protected RestMatcherList.Builder createMatchers(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)RestMatcherList.create(beanStore)));
            this.defaultClasses().get(RestMatcherList.class).ifPresent(x -> ((RestMatcherList.Builder)((Object)((Object)v.get()))).type((Class)x));
            beanStore.getBean(RestMatcherList.class).ifPresent(x -> ((RestMatcherList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(RestMatcherList.class).addBean(RestMatcherList.Builder.class, (Object)((RestMatcherList.Builder)((Object)v.get()))).find(this::matches).run(x -> ((RestMatcherList.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestMatcherList.Builder)((Object)v.get());
        }

        protected ParserSet.Builder createParsers(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.parsers().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(ParserSet.Builder.class, (Object)((ParserSet.Builder)v.get())).createMethodFinder(ParserSet.class, resource).find(this::matches).run(x -> ((ParserSet.Builder)v.get()).impl(x));
            return (ParserSet.Builder)v.get();
        }

        protected HttpPartParser.Creator createPartParser(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.partParser().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(HttpPartParser.Creator.class, (Object)((HttpPartParser.Creator)v.get())).createMethodFinder(HttpPartParser.class, resource).find(this::matches).run(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            return (HttpPartParser.Creator)v.get();
        }

        protected HttpPartSerializer.Creator createPartSerializer(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.partSerializer().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(HttpPartSerializer.Creator.class, (Object)((HttpPartSerializer.Creator)v.get())).createMethodFinder(HttpPartSerializer.class, resource).find(this::matches).run(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            return (HttpPartSerializer.Creator)v.get();
        }

        protected SerializerSet.Builder createSerializers(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.serializers().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(SerializerSet.Builder.class, (Object)((SerializerSet.Builder)v.get())).createMethodFinder(SerializerSet.class, resource).find(this::matches).run(x -> ((SerializerSet.Builder)v.get()).impl(x));
            return (SerializerSet.Builder)v.get();
        }

        protected Class<? extends RestOpContext> getDefaultImplClass() {
            return RestOpContext.class;
        }

        /*
         * WARNING - void declaration
         */
        protected UrlPathMatcherList getPathMatchers() {
            Value v = Value.of((Object)UrlPathMatcherList.create());
            if (Utils.nn(this.path)) {
                for (String string : this.path) {
                    void var3_3;
                    if (this.dotAll && !string.endsWith("/*")) {
                        String string2 = string + "/*";
                    }
                    ((UrlPathMatcherList)v.get()).add(UrlPathMatcher.of((String)var3_3));
                }
            }
            if (((UrlPathMatcherList)v.get()).isEmpty()) {
                void var3_9;
                MethodInfo mi = MethodInfo.of((Method)this.restMethod);
                String string = null;
                String httpMethod = null;
                if (mi.hasAnnotation(RestGet.class)) {
                    httpMethod = "get";
                } else if (mi.hasAnnotation(RestPut.class)) {
                    httpMethod = "put";
                } else if (mi.hasAnnotation(RestPost.class)) {
                    httpMethod = "post";
                } else if (mi.hasAnnotation(RestDelete.class)) {
                    httpMethod = "delete";
                } else if (mi.hasAnnotation(RestOp.class)) {
                    httpMethod = AP.find(RestOp.class, mi, new AnnotationTraversal[0]).stream().map(x -> ((RestOp)x.inner()).method()).filter(Utils::ne).findFirst().orElse(null);
                }
                String string3 = HttpUtils.detectHttpPath((Method)this.restMethod, (String)httpMethod);
                if (this.dotAll && !string3.endsWith("/*")) {
                    String string4 = string3 + "/*";
                }
                ((UrlPathMatcherList)v.get()).add(UrlPathMatcher.of((String)var3_9));
            }
            this.beanStore.createMethodFinder(UrlPathMatcherList.class, this.resource().get()).addBean(UrlPathMatcherList.class, (Object)((UrlPathMatcherList)v.get())).find(this::matches).run(x -> v.set(x));
            return (UrlPathMatcherList)v.get();
        }

        protected void processParameterAnnotations() {
            for (Annotation[] aa : this.restMethod.getParameterAnnotations()) {
                Schema a2;
                String def = null;
                for (Annotation a : aa) {
                    if (!(a instanceof Schema)) continue;
                    a2 = (Schema)a;
                    def = Builder.joinnlFirstNonEmptyArray(a2.default_(), a2.df());
                }
                for (Annotation a : aa) {
                    if (a instanceof Header) {
                        a2 = (Header)a;
                        if (Utils.nn((Object)def)) {
                            try {
                                this.defaultRequestHeaders().set((org.apache.http.Header)HttpHeaders.basicHeader((String)StringUtils.firstNonEmpty((String[])new String[]{a2.name(), a2.value()}), (Object)RestUtils.parseAnything(def)));
                            }
                            catch (ParseException e) {
                                throw new ConfigException((Throwable)e, "Malformed @Header annotation", new Object[0]);
                            }
                        }
                    }
                    if (a instanceof Query) {
                        a2 = (Query)a;
                        if (Utils.nn((Object)def)) {
                            try {
                                this.defaultRequestQueryData().setDefault(new NameValuePair[]{HttpParts.basicPart((String)StringUtils.firstNonEmpty((String[])new String[]{a2.name(), a2.value()}), (Object)RestUtils.parseAnything(def))});
                            }
                            catch (ParseException e) {
                                throw new ConfigException((Throwable)e, "Malformed @Query annotation", new Object[0]);
                            }
                        }
                    }
                    if (!(a instanceof FormData)) continue;
                    a2 = (FormData)a;
                    if (!Utils.nn((Object)def)) continue;
                    try {
                        this.defaultRequestFormData().setDefault(new NameValuePair[]{HttpParts.basicPart((String)StringUtils.firstNonEmpty((String[])new String[]{a2.name(), a2.value()}), (Object)RestUtils.parseAnything(def))});
                    }
                    catch (ParseException e) {
                        throw new ConfigException((Throwable)e, "Malformed @FormData annotation", new Object[0]);
                    }
                }
            }
        }

        Optional<BeanContext> getBeanContext() {
            return Utils.opt((Object)this.beanContext).map(BeanContext.Builder::build);
        }

        Optional<EncoderSet> getEncoders() {
            return Utils.opt((Object)this.encoders).map(BeanBuilder::build);
        }

        RestGuardList getGuards() {
            RestGuardList.Builder b = this.guards();
            Set roleGuard = Utils.opt(this.roleGuard).orElseGet(() -> CollectionUtils.set((Object[])new String[0]));
            for (String rg : roleGuard) {
                try {
                    b.append(new RoleBasedRestGuard(this.rolesDeclared, rg));
                }
                catch (java.text.ParseException e1) {
                    throw ThrowableUtils.toRex((Throwable)e1);
                }
            }
            return (RestGuardList)this.guards.build();
        }

        Optional<JsonSchemaGenerator> getJsonSchemaGenerator() {
            return Utils.opt((Object)this.jsonSchemaGenerator).map(JsonSchemaGenerator.Builder::build);
        }

        RestMatcherList getMatchers(RestContext restContext) {
            RestMatcherList.Builder b = this.matchers();
            if (Utils.nn((Object)this.clientVersion)) {
                b.append(new ClientVersionMatcher(restContext.getClientVersionHeader(), MethodInfo.of((Method)this.restMethod)));
            }
            return (RestMatcherList)b.build();
        }

        Optional<ParserSet> getParsers() {
            return Utils.opt((Object)this.parsers).map(BeanBuilder::build);
        }

        Optional<HttpPartParser> getPartParser() {
            return Utils.opt((Object)this.partParser).map(ContextBeanCreator::create);
        }

        Optional<HttpPartSerializer> getPartSerializer() {
            return Utils.opt((Object)this.partSerializer).map(ContextBeanCreator::create);
        }

        Optional<SerializerSet> getSerializers() {
            return Utils.opt((Object)this.serializers).map(BeanBuilder::build);
        }
    }
}

