/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class ServerVariable
extends OpenApiElement {
    private List<Object> enum_ = CollectionUtils.list(new Object[0]);
    private String default_;
    private String description;

    public ServerVariable() {
    }

    public ServerVariable(ServerVariable copyFrom) {
        super(copyFrom);
        if (Utils.nn(copyFrom.enum_)) {
            this.enum_.addAll(CollectionUtils.copyOf(copyFrom.enum_));
        }
        this.default_ = copyFrom.default_;
        this.description = copyFrom.description;
    }

    public ServerVariable addEnum(Object ... values) {
        if (Utils.nn(values)) {
            for (Object v : values) {
                if (!Utils.nn(v)) continue;
                this.enum_.add(v);
            }
        }
        return this;
    }

    public ServerVariable copy() {
        return new ServerVariable(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "enum" -> ConverterUtils.toType(this.getEnum(), type);
            case "default" -> ConverterUtils.toType(this.getDefault(), type);
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            default -> super.get(property, type);
        };
    }

    public String getDefault() {
        return this.default_;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Object> getEnum() {
        return Utils.nullIfEmpty(this.enum_);
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.default_), "default").addIf(Utils.nn(this.description), "description").addIf(Utils.ne(this.enum_), "enum").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public ServerVariable set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "default" -> this.setDefault(Utils.s(value));
            case "description" -> this.setDescription(Utils.s(value));
            case "enum" -> this.setEnum(CollectionUtils.listb(Object.class).addAny(value).sparse().build());
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public ServerVariable setDefault(String value) {
        this.default_ = value;
        return this;
    }

    public ServerVariable setDescription(String value) {
        this.description = value;
        return this;
    }

    public ServerVariable setEnum(Collection<Object> value) {
        this.enum_.clear();
        if (Utils.nn(value)) {
            this.enum_.addAll(value);
        }
        return this;
    }

    @Override
    public ServerVariable strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected ServerVariable strict() {
        super.strict();
        return this;
    }
}

