/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.storage.log;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.server.storage.log.FetchIsolation;

public class FetchParams {
    public final short requestVersion;
    public final int replicaId;
    public final long replicaEpoch;
    public final long maxWaitMs;
    public final int minBytes;
    public final int maxBytes;
    public final FetchIsolation isolation;
    public final Optional<ClientMetadata> clientMetadata;
    public final boolean shareFetchRequest;

    public FetchParams(short requestVersion, int replicaId, long replicaEpoch, long maxWaitMs, int minBytes, int maxBytes, FetchIsolation isolation, Optional<ClientMetadata> clientMetadata) {
        this(requestVersion, replicaId, replicaEpoch, maxWaitMs, minBytes, maxBytes, isolation, clientMetadata, false);
    }

    public FetchParams(short requestVersion, int replicaId, long replicaEpoch, long maxWaitMs, int minBytes, int maxBytes, FetchIsolation isolation, Optional<ClientMetadata> clientMetadata, boolean shareFetchRequest) {
        Objects.requireNonNull(isolation);
        Objects.requireNonNull(clientMetadata);
        this.requestVersion = requestVersion;
        this.replicaId = replicaId;
        this.replicaEpoch = replicaEpoch;
        this.maxWaitMs = maxWaitMs;
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
        this.isolation = isolation;
        this.clientMetadata = clientMetadata;
        this.shareFetchRequest = shareFetchRequest;
    }

    public boolean isFromFollower() {
        return FetchRequest.isValidBrokerId((int)this.replicaId);
    }

    public boolean isFromFuture() {
        return this.replicaId == -3;
    }

    public boolean isFromConsumer() {
        return FetchRequest.isConsumer((int)this.replicaId);
    }

    public boolean fetchOnlyLeader() {
        return this.isFromFollower() || this.isFromConsumer() && !this.clientMetadata.isPresent() || this.shareFetchRequest;
    }

    public boolean hardMaxBytesLimit() {
        return this.requestVersion <= 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchParams that = (FetchParams)o;
        return this.requestVersion == that.requestVersion && this.replicaId == that.replicaId && this.replicaEpoch == that.replicaEpoch && this.maxWaitMs == that.maxWaitMs && this.minBytes == that.minBytes && this.maxBytes == that.maxBytes && this.isolation.equals((Object)that.isolation) && this.clientMetadata.equals(that.clientMetadata) && this.shareFetchRequest == that.shareFetchRequest;
    }

    public int hashCode() {
        int result = this.requestVersion;
        result = 31 * result + this.replicaId;
        result = 31 * result + (int)this.replicaEpoch;
        result = 31 * result + Long.hashCode(32L);
        result = 31 * result + this.minBytes;
        result = 31 * result + this.maxBytes;
        result = 31 * result + this.isolation.hashCode();
        result = 31 * result + this.clientMetadata.hashCode();
        result = 31 * result + Boolean.hashCode(this.shareFetchRequest);
        return result;
    }

    public String toString() {
        return "FetchParams(requestVersion=" + this.requestVersion + ", replicaId=" + this.replicaId + ", replicaEpoch=" + this.replicaEpoch + ", maxWaitMs=" + this.maxWaitMs + ", minBytes=" + this.minBytes + ", maxBytes=" + this.maxBytes + ", isolation=" + String.valueOf((Object)this.isolation) + ", clientMetadata=" + String.valueOf(this.clientMetadata) + ", shareFetchRequest=" + this.shareFetchRequest + ")";
    }
}

