/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.time.Instant;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;

public interface WindowStore<K, V>
extends StateStore,
ReadOnlyWindowStore<K, V> {
    public void put(K var1, V var2, long var3);

    public WindowStoreIterator<V> fetch(K var1, long var2, long var4);

    @Override
    default public WindowStoreIterator<V> fetch(K key, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return this.fetch(key, ApiUtils.validateMillisecondInstant(timeFrom, ApiUtils.prepareMillisCheckFailMsgPrefix(timeFrom, "timeFrom")), ApiUtils.validateMillisecondInstant(timeTo, ApiUtils.prepareMillisCheckFailMsgPrefix(timeTo, "timeTo")));
    }

    default public WindowStoreIterator<V> backwardFetch(K key, long timeFrom, long timeTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public WindowStoreIterator<V> backwardFetch(K key, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return this.backwardFetch(key, ApiUtils.validateMillisecondInstant(timeFrom, ApiUtils.prepareMillisCheckFailMsgPrefix(timeFrom, "timeFrom")), ApiUtils.validateMillisecondInstant(timeTo, ApiUtils.prepareMillisCheckFailMsgPrefix(timeTo, "timeTo")));
    }

    public KeyValueIterator<Windowed<K>, V> fetch(K var1, K var2, long var3, long var5);

    @Override
    default public KeyValueIterator<Windowed<K>, V> fetch(K keyFrom, K keyTo, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return this.fetch(keyFrom, keyTo, ApiUtils.validateMillisecondInstant(timeFrom, ApiUtils.prepareMillisCheckFailMsgPrefix(timeFrom, "timeFrom")), ApiUtils.validateMillisecondInstant(timeTo, ApiUtils.prepareMillisCheckFailMsgPrefix(timeTo, "timeTo")));
    }

    default public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo, long timeFrom, long timeTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public KeyValueIterator<Windowed<K>, V> backwardFetch(K keyFrom, K keyTo, Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return this.backwardFetch(keyFrom, keyTo, ApiUtils.validateMillisecondInstant(timeFrom, ApiUtils.prepareMillisCheckFailMsgPrefix(timeFrom, "timeFrom")), ApiUtils.validateMillisecondInstant(timeTo, ApiUtils.prepareMillisCheckFailMsgPrefix(timeTo, "timeTo")));
    }

    public KeyValueIterator<Windowed<K>, V> fetchAll(long var1, long var3);

    @Override
    default public KeyValueIterator<Windowed<K>, V> fetchAll(Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return this.fetchAll(ApiUtils.validateMillisecondInstant(timeFrom, ApiUtils.prepareMillisCheckFailMsgPrefix(timeFrom, "timeFrom")), ApiUtils.validateMillisecondInstant(timeTo, ApiUtils.prepareMillisCheckFailMsgPrefix(timeTo, "timeTo")));
    }

    default public KeyValueIterator<Windowed<K>, V> backwardFetchAll(long timeFrom, long timeTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public KeyValueIterator<Windowed<K>, V> backwardFetchAll(Instant timeFrom, Instant timeTo) throws IllegalArgumentException {
        return this.backwardFetchAll(ApiUtils.validateMillisecondInstant(timeFrom, ApiUtils.prepareMillisCheckFailMsgPrefix(timeFrom, "timeFrom")), ApiUtils.validateMillisecondInstant(timeTo, ApiUtils.prepareMillisCheckFailMsgPrefix(timeTo, "timeTo")));
    }
}

