/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;

public class CachedSharePartition
implements ImplicitLinkedHashCollection.Element {
    private final String topic;
    private final Uuid topicId;
    private final int partition;
    private final Optional<Integer> leaderEpoch;
    private int maxBytes;
    private boolean requiresUpdateInResponse;
    private int cachedNext = -2;
    private int cachedPrev = -2;

    private CachedSharePartition(String topic, Uuid topicId, int partition, int maxBytes, Optional<Integer> leaderEpoch, boolean requiresUpdateInResponse) {
        this.topic = topic;
        this.topicId = topicId;
        this.partition = partition;
        this.maxBytes = maxBytes;
        this.leaderEpoch = leaderEpoch;
        this.requiresUpdateInResponse = requiresUpdateInResponse;
    }

    public CachedSharePartition(String topic, Uuid topicId, int partition, boolean requiresUpdateInResponse) {
        this(topic, topicId, partition, -1, Optional.empty(), requiresUpdateInResponse);
    }

    public CachedSharePartition(TopicIdPartition topicIdPartition) {
        this(topicIdPartition.topic(), topicIdPartition.topicId(), topicIdPartition.partition(), false);
    }

    public CachedSharePartition(TopicIdPartition topicIdPartition, ShareFetchRequest.SharePartitionData reqData, boolean requiresUpdateInResponse) {
        this(topicIdPartition.topic(), topicIdPartition.topicId(), topicIdPartition.partition(), reqData.maxBytes, Optional.empty(), requiresUpdateInResponse);
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public ShareFetchRequest.SharePartitionData reqData() {
        return new ShareFetchRequest.SharePartitionData(this.topicId, this.maxBytes);
    }

    public void updateRequestParams(ShareFetchRequest.SharePartitionData reqData) {
        this.maxBytes = reqData.maxBytes;
    }

    public boolean maybeUpdateResponseData(ShareFetchResponseData.PartitionData respData, boolean updateResponseData) {
        boolean mustRespond = false;
        if (ShareFetchResponse.recordsSize((ShareFetchResponseData.PartitionData)respData) > 0) {
            mustRespond = true;
        }
        if (this.requiresUpdateInResponse) {
            mustRespond = true;
            if (updateResponseData) {
                this.requiresUpdateInResponse = false;
            }
        }
        if (respData.errorCode() != Errors.NONE.code()) {
            if (updateResponseData) {
                this.requiresUpdateInResponse = true;
            }
            mustRespond = true;
        }
        return mustRespond;
    }

    public String toString() {
        return "CachedSharePartition(topic=" + this.topic + ", topicId=" + String.valueOf(this.topicId) + ", partition=" + this.partition + ", maxBytes=" + this.maxBytes + ", leaderEpoch=" + String.valueOf(this.leaderEpoch) + ")";
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.topicId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CachedSharePartition that = (CachedSharePartition)obj;
        return this.partition == that.partition && Objects.equals(this.topicId, that.topicId);
    }

    public int prev() {
        return this.cachedPrev;
    }

    public void setPrev(int prev) {
        this.cachedPrev = prev;
    }

    public int next() {
        return this.cachedNext;
    }

    public void setNext(int next) {
        this.cachedNext = next;
    }
}

