/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.ScramMechanismNode;
import org.apache.kafka.metadata.ScramCredentialData;

public class ScramImageNode
implements MetadataNode {
    public static final String NAME = "scram";
    private final ScramImage image;

    public ScramImageNode(ScramImage image) {
        this.image = image;
    }

    @Override
    public Collection<String> childNames() {
        ArrayList<String> childNames = new ArrayList<String>();
        for (ScramMechanism mechanism : ScramMechanism.values()) {
            if (mechanism.equals((Object)ScramMechanism.UNKNOWN)) continue;
            childNames.add(mechanism.mechanismName());
        }
        return childNames;
    }

    @Override
    public MetadataNode child(String name) {
        ScramMechanism mechanism = ScramMechanism.fromMechanismName((String)name);
        if (mechanism.equals((Object)ScramMechanism.UNKNOWN)) {
            return null;
        }
        Map<String, ScramCredentialData> userData = this.image.mechanisms().get(mechanism);
        return new ScramMechanismNode(userData == null ? Collections.emptyMap() : userData);
    }
}

