/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.internals.events.CompletableEvent;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class CompletableEventReaper {
    private final Logger log;
    private final List<CompletableEvent<?>> tracked;

    public CompletableEventReaper(LogContext logContext) {
        this.log = logContext.logger(CompletableEventReaper.class);
        this.tracked = new ArrayList();
    }

    public void add(CompletableEvent<?> event) {
        this.tracked.add(Objects.requireNonNull(event, "Event to track must be non-null"));
    }

    public long reap(long currentTimeMs) {
        Consumer<CompletableEvent> expireEvent = event -> {
            long pastDueMs = currentTimeMs - event.deadlineMs();
            TimeoutException error = new TimeoutException(String.format("%s was %s ms past its expiration of %s", event.getClass().getSimpleName(), pastDueMs, event.deadlineMs()));
            if (event.future().completeExceptionally(error)) {
                this.log.debug("Event {} completed exceptionally since its expiration of {} passed {} ms ago", new Object[]{event, event.deadlineMs(), pastDueMs});
            } else {
                this.log.trace("Event {} not completed exceptionally since it was previously completed", event);
            }
        };
        long count = this.tracked.stream().filter(e -> !e.future().isDone()).filter(e -> currentTimeMs >= e.deadlineMs()).peek(expireEvent).count();
        this.tracked.removeIf(e -> e.future().isDone());
        return count;
    }

    public long reap(Collection<?> events) {
        Objects.requireNonNull(events, "Event queue to reap must be non-null");
        Consumer<CompletableEvent> expireEvent = event -> {
            TimeoutException error = new TimeoutException(String.format("%s could not be completed before the consumer closed", event.getClass().getSimpleName()));
            if (event.future().completeExceptionally(error)) {
                this.log.debug("Event {} completed exceptionally since the consumer is closing", event);
            } else {
                this.log.trace("Event {} not completed exceptionally since it was completed prior to the consumer closing", event);
            }
        };
        long trackedExpiredCount = this.tracked.stream().filter(e -> !e.future().isDone()).peek(expireEvent).count();
        this.tracked.clear();
        long eventExpiredCount = events.stream().filter(e -> e instanceof CompletableEvent).map(e -> (CompletableEvent)e).filter(e -> !e.future().isDone()).peek(expireEvent).count();
        events.clear();
        return trackedExpiredCount + eventExpiredCount;
    }

    public int size() {
        return this.tracked.size();
    }

    public boolean contains(CompletableEvent<?> event) {
        return event != null && this.tracked.contains(event);
    }

    public List<CompletableEvent<?>> uncompletedEvents() {
        return this.tracked.stream().filter(e -> !e.future().isDone()).collect(Collectors.toList());
    }
}

