/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.operation;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.spark.KyuubiSparkUtil$;
import org.apache.kyuubi.engine.spark.operation.SparkOperation;
import org.apache.kyuubi.operation.AnalyzeMode$;
import org.apache.kyuubi.operation.ArrayFetchIterator;
import org.apache.kyuubi.operation.ExecutionMode$;
import org.apache.kyuubi.operation.IterableFetchIterator;
import org.apache.kyuubi.operation.JsonStyle$;
import org.apache.kyuubi.operation.LineageMode$;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.OptimizeMode$;
import org.apache.kyuubi.operation.OptimizeWithStatsMode$;
import org.apache.kyuubi.operation.ParseMode$;
import org.apache.kyuubi.operation.PhysicalMode$;
import org.apache.kyuubi.operation.PlainStyle$;
import org.apache.kyuubi.operation.PlanOnlyMode;
import org.apache.kyuubi.operation.PlanOnlyMode$;
import org.apache.kyuubi.operation.PlanOnlyStyle;
import org.apache.kyuubi.operation.PlanOnlyStyle$;
import org.apache.kyuubi.operation.UnknownMode$;
import org.apache.kyuubi.operation.UnknownStyle$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import org.apache.spark.kyuubi.SparkUtilsHelper$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.CommandExecutionMode$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u000b\u0017\u0001\rB\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t]\u0001\u0011)\u0019!C!_!AQ\b\u0001B\u0001B\u0003%\u0001\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!!\u0005A!b\u0001\n#*\u0005\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b)\u0003A\u0011A&\t\u000fE\u0003!\u0019!C\u0005%\"1\u0011\f\u0001Q\u0001\nMCqA\u0017\u0001C\u0002\u0013%1\f\u0003\u0004`\u0001\u0001\u0006I\u0001\u0018\u0005\bA\u0002\u0011\r\u0011\"\u0003b\u0011\u0019)\u0007\u0001)A\u0005E\")a\r\u0001C!O\")A\u000e\u0001C)[\")q\u000f\u0001C)q\")A\u0010\u0001C)q\")Q\u0010\u0001C\u0005}\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0002\u0012!2\fgn\u00148msN#\u0018\r^3nK:$(BA\f\u0019\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002\u001a5\u0005)1\u000f]1sW*\u00111\u0004H\u0001\u0007K:<\u0017N\\3\u000b\u0005uq\u0012AB6zkV\u0014\u0017N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0011\u0002\"!\n\u0014\u000e\u0003YI!a\n\f\u0003\u001dM\u0003\u0018M]6Pa\u0016\u0014\u0018\r^5p]\u000691/Z:tS>t\u0007C\u0001\u0016-\u001b\u0005Y#B\u0001\u0015\u001d\u0013\ti3FA\u0004TKN\u001c\u0018n\u001c8\u0002\u0013M$\u0018\r^3nK:$X#\u0001\u0019\u0011\u0005ERdB\u0001\u001a9!\t\u0019d'D\u00015\u0015\t)$%\u0001\u0004=e>|GO\u0010\u0006\u0002o\u0005)1oY1mC&\u0011\u0011HN\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:m\u0005Q1\u000f^1uK6,g\u000e\u001e\u0011\u0002\t5|G-\u001a\t\u0003\u0001\nk\u0011!\u0011\u0006\u0003/qI!aQ!\u0003\u0019Ac\u0017M\\(oYflu\u000eZ3\u0002\r!\fg\u000e\u001a7f+\u00051\u0005C\u0001!H\u0013\tA\u0015IA\bPa\u0016\u0014\u0018\r^5p]\"\u000bg\u000e\u001a7f\u0003\u001dA\u0017M\u001c3mK\u0002\na\u0001P5oSRtD#\u0002'N\u001d>\u0003\u0006CA\u0013\u0001\u0011\u0015As\u00011\u0001*\u0011\u0015qs\u00011\u00011\u0011\u0015qt\u00011\u0001@\u0011\u0015!u\u00011\u0001G\u00031y\u0007/\u001a:bi&|g\u000eT8h+\u0005\u0019\u0006C\u0001+X\u001b\u0005)&B\u0001,B\u0003\rawnZ\u0005\u00031V\u0013Ab\u00149fe\u0006$\u0018n\u001c8M_\u001e\fQb\u001c9fe\u0006$\u0018n\u001c8M_\u001e\u0004\u0013\u0001\u00049mC:,\u0005p\u00197vI\u0016\u001cX#\u0001/\u0011\u0007Ej\u0006'\u0003\u0002_y\t\u00191+\u001a;\u0002\u001bAd\u0017M\\#yG2,H-Z:!\u0003\u0015\u0019H/\u001f7f+\u0005\u0011\u0007C\u0001!d\u0013\t!\u0017IA\u0007QY\u0006twJ\u001c7z'RLH.Z\u0001\u0007gRLH.\u001a\u0011\u0002\u001f\u001d,Go\u00149fe\u0006$\u0018n\u001c8M_\u001e,\u0012\u0001\u001b\t\u0004S*\u001cV\"\u0001\u001c\n\u0005-4$AB(qi&|g.\u0001\u0007sKN,H\u000e^*dQ\u0016l\u0017-F\u0001o!\tyW/D\u0001q\u0015\t\t(/A\u0003usB,7O\u0003\u0002ti\u0006\u00191/\u001d7\u000b\u0005eq\u0012B\u0001<q\u0005)\u0019FO];diRK\b/Z\u0001\nE\u00164wN]3Sk:$\u0012!\u001f\t\u0003SjL!a\u001f\u001c\u0003\tUs\u0017\u000e^\u0001\feVt\u0017J\u001c;fe:\fG.A\u000bfqBd\u0017-\u001b8XSRD\u0007\u000b\\1j]N#\u0018\u0010\\3\u0015\u0005e|\bbBA\u0001%\u0001\u0007\u00111A\u0001\u0005a2\fg\u000e\u0005\u0003\u0002\u0006\u0005MQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u000f1|w-[2bY*!\u0011QBA\b\u0003\u0015\u0001H.\u00198t\u0015\r\t\tB]\u0001\tG\u0006$\u0018\r\\=ti&!\u0011QCA\u0004\u0005-aunZ5dC2\u0004F.\u00198\u0002)\u0015D\b\u000f\\1j]^KG\u000f\u001b&t_:\u001cF/\u001f7f)\rI\u00181\u0004\u0005\b\u0003\u0003\u0019\u0002\u0019AA\u0002\u00031\u0001\u0018M]:f\u0019&tW-Y4f)\u0015\u0001\u0014\u0011EA\u0016\u0011\u0019IB\u00031\u0001\u0002$A!\u0011QEA\u0014\u001b\u0005\u0011\u0018bAA\u0015e\na1\u000b]1sWN+7o]5p]\"9\u0011\u0011\u0001\u000bA\u0002\u0005\r\u0001")
public class PlanOnlyStatement
extends SparkOperation {
    private final Session session;
    private final String statement;
    private final PlanOnlyMode mode;
    private final OperationHandle handle;
    private final OperationLog operationLog;
    private final Set<String> planExcludes;
    private final PlanOnlyStyle style;

    @Override
    public String statement() {
        return this.statement;
    }

    @Override
    public OperationHandle handle() {
        return this.handle;
    }

    private OperationLog operationLog() {
        return this.operationLog;
    }

    private Set<String> planExcludes() {
        return this.planExcludes;
    }

    private PlanOnlyStyle style() {
        return this.style;
    }

    @Override
    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.operationLog());
    }

    @Override
    public StructType resultSchema() {
        if (this.result() == null) {
            return new StructType().add("plan", "string");
        }
        return super.resultSchema();
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this.operationLog());
        super.beforeRun();
    }

    @Override
    public void runInternal() {
        try {
            this.withLocalProperties((Function0 & Serializable & scala.Serializable)() -> SQLConf$.MODULE$.withExistingConf(this.spark().sessionState().conf(), (Function0 & Serializable & scala.Serializable)() -> {
                LogicalPlan parsed;
                LogicalPlan logicalPlan = parsed = this.spark().sessionState().sqlParser().parsePlan(this.statement());
                if (this.planExcludes().contains((Object)logicalPlan.getClass().getSimpleName())) {
                    this.result_$eq((Dataset<Row>)this.spark().sql(this.statement()));
                    this.iter_$eq(new ArrayFetchIterator(this.result().collect()));
                    return BoxedUnit.UNIT;
                }
                PlanOnlyStyle planOnlyStyle = this.style();
                if (PlainStyle$.MODULE$.equals(planOnlyStyle)) {
                    this.explainWithPlainStyle(logicalPlan);
                    return BoxedUnit.UNIT;
                }
                if (JsonStyle$.MODULE$.equals(planOnlyStyle)) {
                    this.explainWithJsonStyle(logicalPlan);
                    return BoxedUnit.UNIT;
                }
                if (UnknownStyle$.MODULE$.equals(planOnlyStyle)) {
                    return PlanOnlyStyle$.MODULE$.unknownStyleError(this.style());
                }
                throw PlanOnlyStyle$.MODULE$.notSupportedStyleError(planOnlyStyle, "Spark SQL");
            }));
        }
        catch (Throwable x$3) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(this.onError$default$1());
            if (catchExpr$1.isDefinedAt((Object)x$3)) {
                catchExpr$1.apply((Object)x$3);
            }
            throw x$3;
        }
    }

    private void explainWithPlainStyle(LogicalPlan plan) {
        PlanOnlyMode planOnlyMode = this.mode;
        if (ParseMode$.MODULE$.equals(planOnlyMode)) {
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{plan.toString()})), (List)Nil$.MODULE$)));
            return;
        }
        if (AnalyzeMode$.MODULE$.equals(planOnlyMode)) {
            LogicalPlan analyzed = this.spark().sessionState().analyzer().execute(plan);
            this.spark().sessionState().analyzer().checkAnalysis(analyzed);
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analyzed.toString()})), (List)Nil$.MODULE$)));
            return;
        }
        if (OptimizeMode$.MODULE$.equals(planOnlyMode)) {
            LogicalPlan analyzed = this.spark().sessionState().analyzer().execute(plan);
            this.spark().sessionState().analyzer().checkAnalysis(analyzed);
            LogicalPlan optimized = (LogicalPlan)this.spark().sessionState().optimizer().execute((TreeNode)analyzed);
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimized.toString()})), (List)Nil$.MODULE$)));
            return;
        }
        if (OptimizeWithStatsMode$.MODULE$.equals(planOnlyMode)) {
            LogicalPlan analyzed = this.spark().sessionState().analyzer().execute(plan);
            this.spark().sessionState().analyzer().checkAnalysis(analyzed);
            LogicalPlan optimized = (LogicalPlan)this.spark().sessionState().optimizer().execute((TreeNode)analyzed);
            optimized.stats();
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimized.treeString(true, true, SQLConf$.MODULE$.get().maxToStringFields(), false)})), (List)Nil$.MODULE$)));
            return;
        }
        if (PhysicalMode$.MODULE$.equals(planOnlyMode)) {
            SparkPlan physical = this.spark().sessionState().executePlan(plan, CommandExecutionMode$.MODULE$.SKIP()).sparkPlan();
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{physical.toString()})), (List)Nil$.MODULE$)));
            return;
        }
        if (ExecutionMode$.MODULE$.equals(planOnlyMode)) {
            SparkPlan executed = this.spark().sessionState().executePlan(plan, CommandExecutionMode$.MODULE$.SKIP()).executedPlan();
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executed.toString()})), (List)Nil$.MODULE$)));
            return;
        }
        if (LineageMode$.MODULE$.equals(planOnlyMode)) {
            String result = this.parseLineage(this.spark(), plan);
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result})), (List)Nil$.MODULE$)));
            return;
        }
        if (UnknownMode$.MODULE$.equals(planOnlyMode)) {
            throw PlanOnlyMode$.MODULE$.unknownModeError(this.mode);
        }
        throw PlanOnlyMode$.MODULE$.notSupportedModeError(this.mode, "Spark SQL");
    }

    private void explainWithJsonStyle(LogicalPlan plan) {
        PlanOnlyMode planOnlyMode = this.mode;
        if (ParseMode$.MODULE$.equals(planOnlyMode)) {
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{plan.toJSON()})), (List)Nil$.MODULE$)));
            return;
        }
        if (AnalyzeMode$.MODULE$.equals(planOnlyMode)) {
            LogicalPlan analyzed = this.spark().sessionState().analyzer().execute(plan);
            this.spark().sessionState().analyzer().checkAnalysis(analyzed);
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{analyzed.toJSON()})), (List)Nil$.MODULE$)));
            return;
        }
        if (OptimizeMode$.MODULE$.equals(planOnlyMode) ? true : OptimizeWithStatsMode$.MODULE$.equals(planOnlyMode)) {
            LogicalPlan analyzed = this.spark().sessionState().analyzer().execute(plan);
            this.spark().sessionState().analyzer().checkAnalysis(analyzed);
            LogicalPlan optimized = (LogicalPlan)this.spark().sessionState().optimizer().execute((TreeNode)analyzed);
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimized.toJSON()})), (List)Nil$.MODULE$)));
            return;
        }
        if (PhysicalMode$.MODULE$.equals(planOnlyMode)) {
            SparkPlan physical = this.spark().sessionState().executePlan(plan, CommandExecutionMode$.MODULE$.SKIP()).sparkPlan();
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{physical.toJSON()})), (List)Nil$.MODULE$)));
            return;
        }
        if (ExecutionMode$.MODULE$.equals(planOnlyMode)) {
            SparkPlan executed = this.spark().sessionState().executePlan(plan, CommandExecutionMode$.MODULE$.SKIP()).executedPlan();
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{executed.toJSON()})), (List)Nil$.MODULE$)));
            return;
        }
        if (LineageMode$.MODULE$.equals(planOnlyMode)) {
            String result = this.parseLineage(this.spark(), plan);
            this.iter_$eq(new IterableFetchIterator((Iterable)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result})), (List)Nil$.MODULE$)));
            return;
        }
        if (UnknownMode$.MODULE$.equals(planOnlyMode)) {
            throw PlanOnlyMode$.MODULE$.unknownModeError(this.mode);
        }
        throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(56).append("The operation mode ").append(this.mode).append(" doesn't support in Spark SQL engine.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
    }

    private String parseLineage(SparkSession spark, LogicalPlan plan) {
        String string;
        LogicalPlan analyzed = spark.sessionState().analyzer().execute(plan);
        spark.sessionState().analyzer().checkAnalysis(analyzed);
        LogicalPlan optimized = (LogicalPlan)spark.sessionState().optimizer().execute((TreeNode)analyzed);
        String parserProviderClass = this.session.sessionManager().getConf().get(KyuubiConf$.MODULE$.LINEAGE_PARSER_PLUGIN_PROVIDER());
        try {
            if (!SparkUtilsHelper$.MODULE$.classesArePresent(parserProviderClass)) {
                throw new Exception(new StringBuilder(89).append("'").append(parserProviderClass).append("' not found,").append(" need to install kyuubi-spark-lineage plugin before using the 'lineage' mode").toString());
            }
            Object lineage = Class.forName(parserProviderClass).getMethod("parse", SparkSession.class, LogicalPlan.class).invoke(null, spark, optimized);
            ObjectMapper mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            string = mapper.writeValueAsString(lineage);
        }
        catch (Throwable e) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(32).append("Extract columns lineage failed: ").append(e.getMessage()).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return string;
    }

    public PlanOnlyStatement(Session session, String statement, PlanOnlyMode mode, OperationHandle handle) {
        this.session = session;
        this.statement = statement;
        this.mode = mode;
        this.handle = handle;
        super(session);
        this.operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
        this.planExcludes = (Set)this.spark().conf().getOption(KyuubiConf$.MODULE$.OPERATION_PLAN_ONLY_EXCLUDES().key()).map((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.session.sessionManager().getConf().get(KyuubiConf$.MODULE$.OPERATION_PLAN_ONLY_EXCLUDES()));
        this.style = PlanOnlyStyle$.MODULE$.fromString(KyuubiSparkUtil$.MODULE$.getSessionConf(KyuubiConf$.MODULE$.OPERATION_PLAN_ONLY_OUT_STYLE(), this.spark()));
        this.spark().conf().set(KyuubiConf$.MODULE$.OPERATION_PLAN_ONLY_OUT_STYLE().key(), this.style().name());
    }
}

