/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.protocol;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.linkis.cs.server.protocol.HttpResponseProtocol;
import org.apache.linkis.server.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RestResponseProtocol
implements HttpResponseProtocol<Message> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object lock = new Object();
    private Message message;
    private Object responseData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForComplete() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitTimeEnd(long mills) throws InterruptedException {
        this.logger.info(String.format("start to wait %smills until job complete", mills));
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait(mills);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyJob() {
        this.logger.info("notify the job");
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    @Override
    public Message get() {
        return this.message;
    }

    @Override
    public void set(Message message) {
        this.message = message;
    }

    @Override
    public Object getResponseData() {
        return this.responseData;
    }

    @Override
    public void setResponseData(Object responseData) {
        this.responseData = responseData;
    }

    public void ok(String msg) {
        if (this.message == null) {
            this.message = new Message();
        }
        if (StringUtils.isEmpty((Object)msg)) {
            this.message.setMessage("OK");
        } else {
            this.message.setMessage(msg);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.message == null) {
            this.message = new Message();
            this.message.setStatus(1);
        }
        this.message.setMessage(msg);
        if (t != null) {
            this.message.$less$less("stack", (Object)ExceptionUtils.getStackTrace((Throwable)t));
        }
    }
}

