/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.hive.llap.io.ChunkedInputStream;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapBaseRecordReader<V extends WritableComparable>
implements RecordReader<NullWritable, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LlapBaseRecordReader.class);
    protected final ChunkedInputStream cin;
    protected final DataInputStream din;
    protected final Schema schema;
    protected final Class<V> clazz;
    protected Thread readerThread = null;
    protected final LinkedBlockingQueue<ReaderEvent> readerEvents = new LinkedBlockingQueue();
    protected final Closeable client;
    private final Closeable socket;
    private boolean closed = false;

    public LlapBaseRecordReader(InputStream in, Schema schema, Class<V> clazz, JobConf job, Closeable client, Closeable socket) {
        String clientId = client == null ? "" : client.toString();
        this.cin = new ChunkedInputStream(in, clientId);
        this.din = new DataInputStream(new BufferedInputStream(this.cin));
        this.schema = schema;
        this.clazz = clazz;
        this.readerThread = Thread.currentThread();
        this.client = client;
        this.socket = socket;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            Exception caughtException = null;
            try {
                this.din.close();
            }
            catch (Exception err) {
                LOG.error("Error closing input stream:" + err.getMessage(), (Throwable)err);
                caughtException = err;
            }
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception err) {
                    LOG.error("Error closing client:" + err.getMessage(), (Throwable)err);
                    Exception exception = caughtException = caughtException == null ? err : caughtException;
                }
            }
            if (caughtException != null) {
                throw new IOException("Exception during close: " + caughtException.getMessage(), caughtException);
            }
        }
    }

    public long getPos() {
        return 0L;
    }

    public float getProgress() {
        return 0.0f;
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public V createValue() {
        try {
            return (V)((WritableComparable)this.clazz.newInstance());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean next(NullWritable key, V value) throws IOException {
        try {
            this.setReaderThread(Thread.currentThread());
            if (this.hasInput()) {
                value.readFields((DataInput)this.din);
                return true;
            }
            if (!this.cin.isEndOfData()) {
                throw new IOException("Hit end of input, but did not find expected end of data indicator");
            }
            this.processReaderEvent();
            return false;
        }
        catch (IOException io) {
            this.failOnInterruption(io);
            return false;
        }
    }

    protected void processReaderEvent() throws IOException {
        ReaderEvent event = this.getReaderEvent();
        switch (event.getEventType()) {
            case DONE: {
                break;
            }
            default: {
                throw new IOException("Expected reader event with done status, but got " + (Object)((Object)event.getEventType()) + " with message " + event.getMessage());
            }
        }
    }

    protected void failOnInterruption(IOException io) throws IOException {
        try {
            if (Thread.interrupted()) {
                if (this.readerEvents.isEmpty()) {
                    throw io;
                }
                ReaderEvent event = this.getReaderEvent();
                switch (event.getEventType()) {
                    case ERROR: {
                        throw new IOException("Received reader event error: " + event.getMessage(), io);
                    }
                }
                throw new IOException("Got reader event type " + (Object)((Object)event.getEventType()) + ", expected error event", io);
            }
            throw io;
        }
        catch (Throwable throwable) {
            try {
                this.close();
            }
            catch (Exception err) {
                LOG.error("Closing RecordReader due to error and hit another error during close()", (Throwable)err);
            }
            throw throwable;
        }
    }

    public void handleEvent(ReaderEvent event) {
        switch (event.getEventType()) {
            case DONE: {
                this.readerEvents.add(event);
                break;
            }
            case ERROR: {
                this.readerEvents.add(event);
                if (this.readerThread == null) {
                    throw new RuntimeException("Reader thread is unexpectedly null, during ReaderEvent error " + event.getMessage());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Interrupting reader thread due to reader event with error " + event.getMessage());
                }
                this.readerThread.interrupt();
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    LOG.error("Cannot close the socket on error", (Throwable)e);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unhandled ReaderEvent type " + (Object)((Object)event.getEventType()) + " with message " + event.getMessage());
            }
        }
    }

    protected boolean hasInput() throws IOException {
        this.din.mark(1);
        if (this.din.read() >= 0) {
            this.din.reset();
            return true;
        }
        return false;
    }

    protected ReaderEvent getReaderEvent() throws IOException {
        try {
            ReaderEvent event = this.readerEvents.take();
            Preconditions.checkNotNull(event);
            return event;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Interrupted while getting readerEvents, not expected: " + ie.getMessage(), ie);
        }
    }

    protected synchronized void setReaderThread(Thread readerThread) {
        this.readerThread = readerThread;
    }

    protected synchronized Thread getReaderThread() {
        return this.readerThread;
    }

    public static class ReaderEvent {
        protected final EventType eventType;
        protected final String message;

        protected ReaderEvent(EventType type, String message) {
            this.eventType = type;
            this.message = message;
        }

        public static ReaderEvent doneEvent() {
            return new ReaderEvent(EventType.DONE, "");
        }

        public static ReaderEvent errorEvent(String message) {
            return new ReaderEvent(EventType.ERROR, message);
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public String getMessage() {
            return this.message;
        }

        public static enum EventType {
            DONE,
            ERROR;

        }
    }
}

