/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.persistence;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.utils.ResourceUtils;

public class ECResourceInfoRecord {
    private Integer id;
    private String createUser;
    private String labelValue;
    private String ticketId;
    private String serviceInstance;
    private String usedResource;
    private String requestResource;
    private String releasedResource;
    private String ecmInstance;
    private int requestTimes;
    private int usedTimes;
    private int releaseTimes;
    private Date usedTime;
    private Date createTime;
    private Date releaseTime;
    private String logDirSuffix;
    private String status;
    private String metrics;

    public ECResourceInfoRecord() {
    }

    public ECResourceInfoRecord(String labelValue, String createUser, String ticketId, Resource resource, String logDirSuffix) {
        this.labelValue = labelValue;
        this.ticketId = ticketId;
        this.createUser = createUser;
        if (null != resource) {
            this.requestResource = ResourceUtils.serializeResource(resource);
        }
        this.logDirSuffix = logDirSuffix;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getLabelValue() {
        return this.labelValue;
    }

    public String getEngineType() {
        if (StringUtils.isNotBlank((CharSequence)this.labelValue)) {
            return this.labelValue.split(",")[1].split("-")[0];
        }
        return "";
    }

    public void setLabelValue(String labelValue) {
        this.labelValue = labelValue;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public String getServiceInstance() {
        return this.serviceInstance;
    }

    public void setServiceInstance(String serviceInstance) {
        this.serviceInstance = serviceInstance;
    }

    public String getUsedResource() {
        return this.usedResource;
    }

    public void setUsedResource(String usedResource) {
        this.usedResource = usedResource;
    }

    public Date getUsedTime() {
        return this.usedTime;
    }

    public void setUsedTime(Date usedTime) {
        this.usedTime = usedTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRequestResource() {
        return this.requestResource;
    }

    public void setRequestResource(String requestResource) {
        this.requestResource = requestResource;
    }

    public String getReleasedResource() {
        return this.releasedResource;
    }

    public void setReleasedResource(String releasedResource) {
        this.releasedResource = releasedResource;
    }

    public int getRequestTimes() {
        return this.requestTimes;
    }

    public void setRequestTimes(int requestTimes) {
        this.requestTimes = requestTimes;
    }

    public int getUsedTimes() {
        return this.usedTimes;
    }

    public void setUsedTimes(int usedTimes) {
        this.usedTimes = usedTimes;
    }

    public int getReleaseTimes() {
        return this.releaseTimes;
    }

    public void setReleaseTimes(int releaseTimes) {
        this.releaseTimes = releaseTimes;
    }

    public Date getReleaseTime() {
        return this.releaseTime;
    }

    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }

    public String getEcmInstance() {
        return this.ecmInstance;
    }

    public void setEcmInstance(String ecmInstance) {
        this.ecmInstance = ecmInstance;
    }

    public String getLogDirSuffix() {
        return this.logDirSuffix;
    }

    public void setLogDirSuffix(String logDirSuffix) {
        this.logDirSuffix = logDirSuffix;
    }

    public String getCreateUser() {
        return this.createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMetrics() {
        return this.metrics;
    }

    public void setMetrics(String metrics) {
        this.metrics = metrics;
    }

    public String toString() {
        return "ECResourceInfoRecord{createUser='" + this.createUser + '\'' + ", ticketId='" + this.ticketId + '\'' + ", serviceInstance='" + this.serviceInstance + '\'' + '}';
    }
}

