/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.gateway.security.oauth;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.gateway.config.GatewayConfiguration$;
import org.apache.linkis.gateway.http.GatewayContext;
import org.apache.linkis.gateway.security.GatewaySSOUtils$;
import org.apache.linkis.gateway.security.SecurityFilter$;
import org.apache.linkis.gateway.security.oauth.HttpUtils$;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.Message$;
import org.apache.linkis.server.conf.ServerConfiguration$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class OAuth2Authentication$
implements Logging {
    public static OAuth2Authentication$ MODULE$;
    private final ObjectMapper objectMapper;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new OAuth2Authentication$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        OAuth2Authentication$ oAuth2Authentication$ = this;
        synchronized (oAuth2Authentication$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOAuth2Request(GatewayContext gatewayContext) {
        String path;
        String string = path = this.getMethod(gatewayContext);
        String string2 = "oauth_login";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = path;
        String string4 = "oauth_redirect";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public boolean OAuth2Entry(GatewayContext gatewayContext, boolean login) {
        String path;
        String string = path = this.getMethod(gatewayContext);
        String string2 = "oauth_redirect";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.OAuth2Redirect(gatewayContext);
        }
        String string3 = path;
        String string4 = "oauth_redirect";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return this.OAuth2Auth(gatewayContext, login);
        }
        Message message = Message$.MODULE$.noLogin("\u672a\u77e5 OAuth \u8bf7\u6c42").$less$less(gatewayContext.getRequest().getRequestURI());
        SecurityFilter$.MODULE$.filterResponse(gatewayContext, message);
        return false;
    }

    public boolean OAuth2Entry$default$2() {
        return false;
    }

    private String getMethod(GatewayContext gatewayContext) {
        String userURI = (String)ServerConfiguration$.MODULE$.BDP_SERVER_USER_URI().getValue();
        if (!userURI.endsWith("/")) {
            userURI = new StringBuilder(1).append(userURI).append("/").toString();
        }
        String path = gatewayContext.getRequest().getRequestURI().replace(userURI, "");
        return path;
    }

    public boolean OAuth2Redirect(GatewayContext gatewayContext) {
        if (!BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_OAUTH_AUTHENTICATION().getValue())) {
            Message message = Message$.MODULE$.noLogin("Gateway \u672a\u542f\u7528 OAuth \u8ba4\u8bc1\uff0c\u8bf7\u91c7\u7528\u5176\u4ed6\u8ba4\u8bc1\u65b9\u5f0f!").$less$less(gatewayContext.getRequest().getRequestURI());
            SecurityFilter$.MODULE$.filterResponse(gatewayContext, message);
            return false;
        }
        Message message = Message$.MODULE$.ok("\u521b\u5efa\u94fe\u63a5\u6210\u529f\uff01").data("redirectUrl", (Object)this.generateAuthenticationUrl());
        SecurityFilter$.MODULE$.filterResponse(gatewayContext, message);
        return true;
    }

    private String generateAuthenticationUrl() {
        String oauthServerUrl;
        block0: {
            oauthServerUrl = new StringBuilder(30).append(GatewayConfiguration$.MODULE$.OAUTH_AUTHENTICATION_URL().getValue()).append("?client_id=").append(GatewayConfiguration$.MODULE$.OAUTH_CLIENT_ID().getValue()).append("&response_type=code").toString();
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)GatewayConfiguration$.MODULE$.OAUTH_SCOPE().getValue()))) break block0;
            oauthServerUrl = new StringBuilder(7).append(oauthServerUrl).append("&scope=").append(GatewayConfiguration$.MODULE$.OAUTH_SCOPE().getValue()).toString();
        }
        return oauthServerUrl;
    }

    public boolean OAuth2Auth(GatewayContext gatewayContext, boolean login) {
        if (!BoxesRunTime.unboxToBoolean((Object)GatewayConfiguration$.MODULE$.ENABLE_OAUTH_AUTHENTICATION().getValue())) {
            Message message = Message$.MODULE$.noLogin("Gateway \u672a\u542f\u7528 OAuth \u8ba4\u8bc1\uff0c\u8bf7\u91c7\u7528\u5176\u4ed6\u8ba4\u8bc1\u65b9\u5f0f!").$less$less(gatewayContext.getRequest().getRequestURI());
            SecurityFilter$.MODULE$.filterResponse(gatewayContext, message);
            return false;
        }
        String code = this.extractCode(gatewayContext);
        String host = gatewayContext.getRequest().getRequestRealIpAddr();
        if (StringUtils.isBlank((CharSequence)code)) {
            Message message = Message$.MODULE$.noLogin("\u8bf7\u5728\u56de\u8c03\u67e5\u8be2\u53c2\u6570\u4e2d\u8fd4\u56decode\uff0c\u4ee5\u4fbf\u5b8c\u6210OAuth\u8ba4\u8bc1\uff01").$less$less(gatewayContext.getRequest().getRequestURI());
            SecurityFilter$.MODULE$.filterResponse(gatewayContext, message);
            return false;
        }
        ObjectRef authMsg = ObjectRef.create((Object)Message$.MODULE$.noLogin(new StringBuilder(23).append("\u65e0\u6548\u7684\u8bbf\u95ee\u4ee4\u724c ").append(code).append("\uff0c\u65e0\u6cd5\u5b8c\u6210 OAuth \u8ba4\u8bc1!").toString()).$less$less(gatewayContext.getRequest().getRequestURI()));
        String accessToken = (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> MODULE$.exchangeAccessToken(code, host), (Function1 & Serializable & scala.Serializable)t -> {
            authMsg$1.elem = Message$.MODULE$.noLogin(new StringBuilder(39).append("OAuth exchange failed, code: ").append(code).append(", reason: ").append(t.getMessage()).toString()).$less$less(gatewayContext.getRequest().getRequestURI());
            return null;
        });
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            String username = this.validateAccessToken(accessToken, host);
            this.logger().info(new StringBuilder(63).append("OAuth authentication succeed, uri: ").append(gatewayContext.getRequest().getRequestURI()).append(", accessToken: ").append(accessToken).append(", username: ").append(username).append(".").toString());
            if (login) {
                GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext, username);
                Message msg = Message$.MODULE$.ok("login successful(\u767b\u5f55\u6210\u529f)\uff01").data("userName", (Object)username).data("enableWatermark", GatewayConfiguration$.MODULE$.ENABLE_WATER_MARK().getValue()).data("isAdmin", (Object)BoxesRunTime.boxToBoolean((boolean)false));
                SecurityFilter$.MODULE$.filterResponse(gatewayContext, msg);
                return true;
            }
            GatewaySSOUtils$.MODULE$.setLoginUser(gatewayContext.getRequest(), username, GatewaySSOUtils$.MODULE$.setLoginUser$default$3());
            return true;
        }
        this.logger().info(new StringBuilder(43).append("OAuth exchange fail, uri: ").append(gatewayContext.getRequest().getRequestURI()).append(", code: ").append(code).append(", host: ").append(host).append(".").toString());
        SecurityFilter$.MODULE$.filterResponse(gatewayContext, (Message)authMsg.elem);
        return false;
    }

    public boolean OAuth2Auth$default$2() {
        return false;
    }

    private String extractCode(GatewayContext gatewayContext) {
        return (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> gatewayContext.getRequest().getQueryParams().get("code")[0], (Function1 & Serializable & scala.Serializable)x$1 -> null);
    }

    private String exchangeAccessToken(String code, String host) {
        String exchangeUrl;
        block1: {
            exchangeUrl = (String)GatewayConfiguration$.MODULE$.OAUTH_EXCHANGE_URL().getValue();
            if (StringUtils.isBlank((CharSequence)exchangeUrl)) {
                this.logger().warn("OAuth exchange url is not set");
            }
            if (!StringUtils.isBlank((CharSequence)code)) break block1;
            this.logger().warn("OAuth exchange code is empty");
        }
        return (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            String response = HttpUtils$.MODULE$.post(exchangeUrl, MODULE$.objectMapper().writeValueAsString((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_id"), GatewayConfiguration$.MODULE$.OAUTH_CLIENT_ID().getValue()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret"), GatewayConfiguration$.MODULE$.OAUTH_CLIENT_SECRET().getValue()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"code"), (Object)code), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"host"), (Object)host)}))), HttpUtils$.MODULE$.post$default$3());
            return (String)((MapLike)MODULE$.objectMapper().readValue(response, Map.class)).get((Object)"access_token").orNull(Predef$.MODULE$.$conforms());
        }, (Function1 & Serializable & scala.Serializable)t -> {
            MODULE$.logger().warn(new StringBuilder(38).append("OAuth exchange failed, url: ").append(exchangeUrl).append(", reason: ").append(t.getMessage()).toString());
            return null;
        });
    }

    private String validateAccessToken(String accessToken, String host) {
        String url;
        block1: {
            url = (String)GatewayConfiguration$.MODULE$.OAUTH_VALIDATE_URL().getValue();
            if (StringUtils.isBlank((CharSequence)url)) {
                this.logger().warn("OAuth validate url is not set");
            }
            if (!StringUtils.isBlank((CharSequence)accessToken)) break block1;
            this.logger().warn("OAuth validate accessToken is empty");
        }
        return (String)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            String response = HttpUtils$.MODULE$.get(url, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Authorization"), (Object)new StringBuilder(7).append("Bearer ").append(accessToken).toString())}))), HttpUtils$.MODULE$.get$default$3());
            return (String)((MapLike)MODULE$.objectMapper().readValue(response, Map.class)).get(GatewayConfiguration$.MODULE$.OAUTH_VALIDATE_FIELD().getValue()).orNull(Predef$.MODULE$.$conforms());
        }, (Function1 & Serializable & scala.Serializable)t -> {
            MODULE$.logger().warn(new StringBuilder(38).append("OAuth validate failed, url: ").append(url).append(", reason: ").append(t.getMessage()).toString());
            return null;
        });
    }

    private OAuth2Authentication$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.objectMapper = new ObjectMapper();
        this.objectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
    }
}

