/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.rpc.message.method;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.linkis.protocol.message.RequestProtocol;
import org.apache.linkis.rpc.message.exception.MessageWarnException;
import org.apache.linkis.rpc.message.method.MethodExecuteWrapper;
import org.apache.linkis.rpc.message.parser.ServiceMethod;
import org.apache.linkis.rpc.message.registry.SpringServiceRegistry;
import org.apache.linkis.rpc.message.utils.MessageUtils;

public class ReceiverMethodSearcher {
    private final Map<String, Map<String, List<ServiceMethod>>> protocolServiceMethodCache = new ConcurrentHashMap<String, Map<String, List<ServiceMethod>>>();
    private SpringServiceRegistry serviceRegistry;

    private void initRegistry() {
        this.serviceRegistry = new SpringServiceRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Map<String, List<MethodExecuteWrapper>> getMethodExecuteWrappers(RequestProtocol requestProtocol) {
        List value;
        Integer repeatOrder;
        String protocolName;
        Map<String, List<ServiceMethod>> protocolServiceMethods;
        if (this.serviceRegistry == null) {
            Class<ReceiverMethodSearcher> clazz = ReceiverMethodSearcher.class;
            // MONITORENTER : org.apache.linkis.rpc.message.method.ReceiverMethodSearcher.class
            if (this.serviceRegistry == null) {
                this.initRegistry();
            }
            // MONITOREXIT : clazz
        }
        if ((protocolServiceMethods = this.protocolServiceMethodCache.get(protocolName = requestProtocol.getClass().getName())) != null) return this.serviceMethod2Wrapper(this.protocolServiceMethodCache.get(protocolName));
        Map<String, List<ServiceMethod>> serviceMethodCache = this.serviceRegistry.getServiceMethodCache();
        Map<String, List> serviceMatchs = serviceMethodCache.entrySet().stream().filter(e -> MessageUtils.isAssignableFrom((String)e.getKey(), protocolName)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        serviceMatchs = serviceMatchs.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(ServiceMethod::getChainName));
        Iterator<List> iterator = serviceMatchs.values().iterator();
        do {
            if (iterator.hasNext()) continue;
            this.protocolServiceMethodCache.put(protocolName, serviceMatchs);
            return this.serviceMethod2Wrapper(this.protocolServiceMethodCache.get(protocolName));
        } while ((repeatOrder = MessageUtils.repeatOrder(value = iterator.next())) == null || MessageUtils.orderIsLast(repeatOrder, value));
        throw new MessageWarnException(10000, String.format("repeat order : %s for request %s", repeatOrder, protocolName));
    }

    private Map<String, List<MethodExecuteWrapper>> serviceMethod2Wrapper(Map<String, List<ServiceMethod>> source) {
        HashMap<String, List<MethodExecuteWrapper>> target = new HashMap<String, List<MethodExecuteWrapper>>();
        source.forEach((k, v) -> target.put((String)k, v.stream().map(MethodExecuteWrapper::new).collect(Collectors.toList())));
        return target;
    }
}

