/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import springfox.documentation.builders.ValidationResult;
import springfox.documentation.builders.Validator;

public class NoopValidator<T>
implements Validator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Validator");

    @Override
    public List<ValidationResult> validate(T builder) {
        return new ArrayList<ValidationResult>();
    }

    static List<ValidationResult> logProblems(List<ValidationResult> results) {
        List<ValidationResult> problems = results.stream().filter(v -> v.getLevel().toInt() > Level.INFO.toInt()).collect(Collectors.toList());
        problems.forEach(v -> LOGGER.debug("{} [{}.{}] {}", new Object[]{v.getLevel(), v.getObject(), v.getField(), v.getMessage()}));
        return problems;
    }
}

