/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.persistence.impl;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.common.entity.label.LabelKeyValue;
import org.apache.linkis.manager.common.entity.persistence.PersistenceLabel;
import org.apache.linkis.manager.common.entity.persistence.PersistenceResource;
import org.apache.linkis.manager.dao.LabelManagerMapper;
import org.apache.linkis.manager.dao.ResourceManagerMapper;
import org.apache.linkis.manager.entity.Tunple;
import org.apache.linkis.manager.exception.PersistenceErrorException;
import org.apache.linkis.manager.label.entity.Label;
import org.apache.linkis.manager.persistence.ResourceLabelPersistence;
import org.apache.linkis.manager.util.PersistenceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;

public class DefaultResourceLabelPersistence
implements ResourceLabelPersistence {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResourceLabelPersistence.class);
    private LabelManagerMapper labelManagerMapper;
    private ResourceManagerMapper resourceManagerMapper;

    public LabelManagerMapper getLabelManagerMapper() {
        return this.labelManagerMapper;
    }

    public void setLabelManagerMapper(LabelManagerMapper labelManagerMapper) {
        this.labelManagerMapper = labelManagerMapper;
    }

    public void setResourceManagerMapper(ResourceManagerMapper resourceManagerMapper) {
        this.resourceManagerMapper = resourceManagerMapper;
    }

    @Override
    @Deprecated
    public List<PersistenceLabel> getResourceLabels(List<LabelKeyValue> labelKeyValues) {
        if (CollectionUtils.isEmpty(labelKeyValues)) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public List<PersistenceLabel> getResourceLabels(Map<String, Map<String, String>> labelKeyAndValuesMap, Label.ValueRelation valueRelation) {
        if (PersistenceUtils.KeyValueMapIsEmpty(labelKeyAndValuesMap)) {
            return Collections.emptyList();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResourceToLabel(PersistenceLabel label, PersistenceResource persistenceResource) {
        List<PersistenceResource> resourceByLabels;
        if (label == null || persistenceResource == null) {
            return;
        }
        if (label.getId() <= 0) {
            if (StringUtils.isEmpty((CharSequence)label.getStringValue())) {
                return;
            }
            PersistenceLabel resourceLabel = this.labelManagerMapper.getLabelByKeyValue(label.getLabelKey(), label.getStringValue());
            if (null == resourceLabel) {
                this.labelManagerMapper.registerLabel(label);
            } else {
                label.setId(resourceLabel.getId());
            }
        }
        if (CollectionUtils.isNotEmpty(resourceByLabels = this.labelManagerMapper.listResourceByLaBelId(label.getId()))) {
            if (resourceByLabels.size() > 1) {
                logger.warn("Label[" + label + "]has resource size > 1");
            }
            PersistenceResource resourceToUpdate = (PersistenceResource)Iterables.getFirst(resourceByLabels, null);
            this.resourceManagerMapper.nodeResourceUpdateByResourceId(resourceToUpdate.getId(), persistenceResource);
        } else {
            DefaultResourceLabelPersistence defaultResourceLabelPersistence = this;
            synchronized (defaultResourceLabelPersistence) {
                List<PersistenceResource> resources = this.labelManagerMapper.listResourceByLaBelId(label.getId());
                if (CollectionUtils.isEmpty(resources)) {
                    persistenceResource.setCreator(persistenceResource.getUpdator());
                    this.resourceManagerMapper.registerResource(persistenceResource);
                    this.labelManagerMapper.addLabelsAndResource(persistenceResource.getId(), Collections.singletonList(label.getId()));
                }
            }
        }
    }

    @Override
    @Retryable(value={CannotGetJdbcConnectionException.class}, maxAttempts=5, backoff=@Backoff(delay=10000L))
    public List<PersistenceResource> getResourceByLabel(PersistenceLabel label) {
        if (label == null) {
            return Collections.emptyList();
        }
        if (label.getId() != null && label.getId() > 0) {
            return this.labelManagerMapper.listResourceByLaBelId(label.getId());
        }
        PersistenceLabel dbLabel = this.labelManagerMapper.getLabelByKeyValue(label.getLabelKey(), label.getStringValue());
        if (null == dbLabel) {
            return Collections.emptyList();
        }
        return this.labelManagerMapper.listResourceByLaBelId(dbLabel.getId());
    }

    @Override
    public void removeResourceByLabel(PersistenceLabel label) throws PersistenceErrorException {
        int labelId = label.getId();
        if (labelId <= 0) {
            PersistenceLabel labelByKeyValue = this.labelManagerMapper.getLabelByKeyValue(label.getLabelKey(), label.getStringValue());
            if (labelByKeyValue == null) {
                throw new PersistenceErrorException(210001, "label not found, this label may be removed already: " + label.getStringValue());
            }
            labelId = labelByKeyValue.getId();
        }
        if (labelId > 0) {
            this.labelManagerMapper.deleteResourceByLabelIdInDirect(labelId);
            this.labelManagerMapper.deleteResourceByLabelId(labelId);
        }
    }

    @Override
    public void removeResourceByLabels(List<PersistenceLabel> labels) {
        List blankIds;
        List notBlankIds = labels.stream().filter(l -> l.getId() != null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notBlankIds)) {
            List<Integer> ids = notBlankIds.stream().map(PersistenceLabel::getId).collect(Collectors.toList());
            this.labelManagerMapper.batchDeleteResourceByLabelId(ids);
            this.labelManagerMapper.batchDeleteResourceByLabelIdInDirect(ids);
        }
        if (CollectionUtils.isNotEmpty(blankIds = labels.stream().filter(l -> l.getId() == null).collect(Collectors.toList()))) {
            Map<String, Map> map = blankIds.stream().map(PersistenceUtils::entryToTunple).collect(Collectors.toMap(Tunple::getKey, Tunple::getValue));
        }
    }
}

