/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.api;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.exceptions.InvalidPathnameException;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.types.RegistryPathStatus;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.service.Service;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface RegistryOperations
extends Service {
    public boolean mknode(String var1, boolean var2) throws PathNotFoundException, InvalidPathnameException, IOException;

    public void bind(String var1, ServiceRecord var2, int var3) throws PathNotFoundException, FileAlreadyExistsException, InvalidPathnameException, IOException;

    public ServiceRecord resolve(String var1) throws PathNotFoundException, NoRecordException, InvalidRecordException, IOException;

    public RegistryPathStatus stat(String var1) throws PathNotFoundException, InvalidPathnameException, IOException;

    public boolean exists(String var1) throws IOException;

    public List<String> list(String var1) throws PathNotFoundException, InvalidPathnameException, IOException;

    public void delete(String var1, boolean var2) throws PathNotFoundException, PathIsNotEmptyDirectoryException, InvalidPathnameException, IOException;

    public boolean addWriteAccessor(String var1, String var2) throws IOException;

    public void clearWriteAccessors();
}

