/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.common.util.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.datasourcemanager.common.errorcode.LinkisDatasourceManagerErrorCodeSummary;
import org.apache.linkis.datasourcemanager.common.exception.JsonErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Json {
    private static final String PREFIX = "[";
    private static final String SUFFIX = "]";
    private static final Logger logger = LoggerFactory.getLogger(Json.class);
    private static ObjectMapper mapper = new ObjectMapper();

    private Json() {
    }

    public static <T> T fromJson(String json, Class<?> clazz, Class<?> ... parameters) throws JsonErrorException {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                if (parameters.length > 0) {
                    return (T)mapper.readValue(json, mapper.getTypeFactory().constructParametricType(clazz, (Class[])parameters));
                }
                if (json.startsWith(PREFIX) && json.endsWith(SUFFIX)) {
                    JavaType javaType = mapper.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{clazz});
                    return (T)mapper.readValue(json, javaType);
                }
                return (T)mapper.readValue(json, clazz);
            }
            catch (Exception e) {
                String message = "Unable to deserialize to object from string(json) in type: [" + (null != clazz ? clazz.getSimpleName() : "UNKNOWN") + "], parameters size: " + parameters.length;
                throw new JsonErrorException(LinkisDatasourceManagerErrorCodeSummary.SERIALIZATION_FAILED.getErrorCode(), message, e);
            }
        }
        return null;
    }

    public static <T> T fromJson(InputStream stream, Class<?> clazz, Class<?> ... parameters) throws JsonErrorException {
        StringBuilder builder = new StringBuilder();
        String jsonStr = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((jsonStr = reader.readLine()) != null) {
                builder.append(jsonStr);
            }
            reader.close();
        }
        catch (Exception e) {
            String message = "Unable to deserialize to object from stream(json) in type: [" + (null != clazz ? clazz.getSimpleName() : "UNKNOWN") + "], parameters size: " + parameters.length;
            throw new JsonErrorException(LinkisDatasourceManagerErrorCodeSummary.SERIALIZATION_FAILED.getErrorCode(), message, e);
        }
        return Json.fromJson(builder.toString(), clazz, parameters);
    }

    public static String toJson(Object obj, Class<?> model) throws JsonErrorException {
        ObjectWriter writer = mapper.writer();
        if (null != obj) {
            try {
                if (null != model) {
                    writer = writer.withView(model);
                }
                return writer.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                String message = "Unable to serialize the object in type: [" + (null != model ? model.getSimpleName() : "UNKNOWN") + SUFFIX;
                throw new JsonErrorException(LinkisDatasourceManagerErrorCodeSummary.CANNOT_BE_SERIALIZATION.getErrorCode(), message, e);
            }
        }
        return null;
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, false);
    }
}

