/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Operation;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.OperationCachingEquivalence;
import springfox.documentation.spring.web.readers.operation.OperationReader;

@Component
@Qualifier(value="cachedOperations")
public class CachingOperationReader
implements OperationReader {
    private final Map<OperationCachingEquivalence.Wrapper, List<Operation>> cache = new HashMap<OperationCachingEquivalence.Wrapper, List<Operation>>();
    private final Function<OperationCachingEquivalence.Wrapper, List<Operation>> lookup = key -> delegate.read(key.get());

    @Autowired
    public CachingOperationReader(@Qualifier(value="default") OperationReader delegate) {
    }

    @Override
    public List<Operation> read(RequestMappingContext outerContext) {
        return this.cache.computeIfAbsent(new OperationCachingEquivalence().wrap(outerContext), this.lookup);
    }
}

